#include "SkinDetector.hpp"
#include "BlobTracker.hpp"
#include "PropagationSkinDetector.hpp"
#include "TrackingSkinDetector.hpp"

using cv::Mat;
using cv::Rect;
using cv::Point;
using cv::Vec3b;
using cv::Scalar;
using cv::Point2f;
using std::string;
using std::map;
using std::set;
using std::cout;
using std::endl;
using std::pair;
using std::vector;

namespace slmotion {

  static BlobTracker DUMMY(true);

  bool BlobTracker::processRangeImplementation(frame_number_t first,
				  frame_number_t last,
                                                UiCallback* /* uiCallback */){

    localBlackBoardType localbb; 

  // the blob progression analysis requires the following information to
   // be put on the local blackboard:

   // frames
   // skin detection mask
   // face detection results

   // old-fashioned blackboard for local info storage

   for(frame_number_t n=first;n<last;n++){
      
     if (!getBlackBoard().has(n, FACEDETECTOR_BLACKBOARD_ENTRY)) 
      throw SLMotionException("No face data on the black board!");

     cv::Rect faceLocation = *getBlackBoard().get<cv::Rect>(n, FACEDETECTOR_BLACKBOARD_ENTRY);
      localbb[std::pair<int,std::string>(n,"frame")]=getFrameSource()[n];
      localbb[std::pair<int,std::string>(n,"skinmask")]=getBlackBoard().get<cv::Mat>(n, SKINDETECTOR_BLACKBOARD_MASK_ENTRY);
      localbb[std::pair<int,std::string>(n,"facerect")]=faceLocation;

   }


   recordBlobProgression(first,last-1,localbb);
   //     cout << "blob progression recorded" << endl;
   interpretBlobs(first,last-1,localbb);
   // cout << "blobs interpreted" << endl;
   recordBlobTracks(first,last-1,localbb);
   for (int f = first; f < static_cast<int>(last); f++)
     if(localbb.count(std::pair<int,std::string>(f,"blobtracks")))
       getBlackBoard().set(f, BLOBTRACKER_BLACKBOARD_ENTRY, 
			   *boost::any_cast<map<int,vector<Rect> > >(&localbb[std::pair<int,std::string>(f,"blobtracks")]));
   
   return true;
   
  }
  
  Component* BlobTracker::createComponentImpl(const boost::program_options::variables_map& /*opts*/, BlackBoard* blackBoard, FrameSource* frameSource) const {

    BlobTracker c(blackBoard, frameSource);
    //    if (opts.count("outputprefix"))
    //      c.outputprefix = opts["outputprefix"].as<std::string>();

    return new BlobTracker(c);

  }


  boost::program_options::options_description BlobTracker::getCommandLineOptionsDescription() const {
    // boost::program_options::options_description opts("BlobTracker options");
    //    opts.add_options()("outputprefix", 
    //                    boost::program_options::value<std::string>(),
    //                   "prefix for output video files (empty -> no avi output)");
    // return opts;
    //
    // it is preferred to return a non-sectioned options_description
    // object because otherwise the help message will be cluttered
    // with pointless, empty option sections
    return boost::program_options::options_description();
  }

}



