#ifndef SLMOTION_BODY_PARTS_FROM_BLOBTRACKS
#define SLMOTION_BODY_PARTS_FROM_BLOBTRACKS

#include "Component.hpp"
#include "Blob.hpp"
#include "BodyPart.hpp"
#include "FaceDetector.hpp"
#include "SkinDetector.hpp"
#include "BlobExtractor.hpp"
#include "BodyPartCollector.hpp"
#include "BlobTracker.hpp"

namespace slmotion {

  /**
   * This component uses blobtracks to generate a list of body parts
   */
  class BodyPartsFromBlobTracks : public Component {
  public:
    explicit BodyPartsFromBlobTracks(bool) : Component(true) {}



    /**
     * Rather a trivial constructor
     */
    BodyPartsFromBlobTracks(BlackBoard* blackBoard, FrameSource* frameSource) :
      Component(blackBoard, frameSource)
      { }



    virtual std::string getShortDescription() const { 
      return "Labels blobs as body parts based on blob tracks";
    };



    virtual std::string getLongDescription() const { 
      return "Labels blobs as body parts based on blob tracks";
    };



    virtual std::string getShortName() const {
      return "BodyPartsFromBlobTracks";
    }



    virtual std::string getComponentName() const {
      return "Body Parts from Blob Tracks";
    }

    virtual boost::program_options::options_description getConfigurationFileOptionsDescription() const {
      return boost::program_options::options_description();
    }

    virtual void reset() { }

    virtual void process(frame_number_t frameNumber);



    inline virtual property_set_t getProvided() const {
      return property_set_t { BODYPARTCOLLECTOR_BLACKBOARD_ENTRY } ;
    }



    inline virtual property_set_t getRequirements() const {
      return property_set_t { FACEDETECTOR_BLACKBOARD_ENTRY,
	  SKINDETECTOR_BLACKBOARD_MASK_ENTRY,
	  BLOBTRACKER_BLACKBOARD_ENTRY };
    }

    virtual boost::program_options::options_description getCommandLineOptionsDescription() const {
      return boost::program_options::options_description();
    }

  private:
    virtual Component* createComponentImpl(const boost::program_options::variables_map& configuration, BlackBoard* blackBoard, FrameSource* frameSource) const;

    std::set<int> lh_cache; // set of blob id's that are interpreted as left hands
    std::set<int> rh_cache; // set of blob id's that are interpreted as right hands

  };
}

#endif

