#ifndef SLMOTION_CLASSIFIER
#define SLMOTION_CLASSIFIER

#include <vector>
#include <cstdlib>
#include <opencv2/opencv.hpp>

namespace slmotion {
  float vectorsqrdist(const std::vector<float> &v1,
		      const std::vector<float> &v2,float min=-1);

  int randomint(int n);


  
  void kmeans(const std::vector<std::vector<float> > &samples,
	      const std::vector<bool> *dimMask,
	      std::vector<size_t> &labels,
	      size_t K,
	      size_t tolerance=0,
	      std::vector<std::vector<float> > *m=NULL);

  float sqrdist(const std::vector<float> &v1,
		const std::vector<float> &v2,
		float mindist);

  int countnbroverlap(bool m1[3][3],bool m2[3][3]);

  float determineStrengthUnderMasks(cv::Mat& mat, size_t y, size_t x, bool *m1, bool *m2);

  std::vector<float> hsvtrig2hsv(const std::vector<float> &src);


  void pseudoinverse(int m, int n, float *a, int lda, int &resm, int &resn,
		     float** res, int &ldres);
  void multiplymat(int m1, int n1, float *a1,int lda1,
		   int m2, int n2, float *a2,int lda2,
		   bool transpose1, bool transpose2,
		   int &resm, int &resn, float** res,int &ldres);
  void invertmatrixinplace(int m, int n, float *a,int lda);
  void print_matrix(const char* desc, int m, int n, float *a, int lda );

  float rcond(int m, int n, float *a, int lda);

  void lapacktests();
  
  float tanhtransfer(float x);

  struct floatMatrix{
    floatMatrix(){ 
      rows=cols=-1;
      dptr=NULL;
    }
    ~floatMatrix(){ delete[] dptr;}
    void allocate(){
      dptr=(rows>0&&cols>0)?new float[rows*cols]:NULL;
    }

    floatMatrix clone() const;

    void writeToFile(FILE *f) const;
    bool readFromFile(FILE *f);
    
    int rows;
    int cols;
    float *dptr; // default interpretation: column major order for BLAS compatibility
  };


}
#endif
