#include "CliCallback.hpp"
#include <iostream>

namespace slmotion {
  extern int debug;

  bool CliCallback::operator()(double percentComplete) {
    if (slmotion::debug == 0)
      return true;

    if (getCurrentComponentIndex() != lastSeenComponentIndex) {
      // os << std::endl;
      lastSeenComponentIndex = getCurrentComponentIndex();
    }

    char percent[10];
    sprintf(percent, "%0.2f %%", percentComplete);
    os << "\rProcessing " << getCurrentComponentName() << ": " << percent
       << std::flush;

    double rem = 100. - percentComplete;
    if (rem < 0.0001)
      os << std::endl;

    return true;
  }

  // void CliCallback::setNComponents(size_t n) {
    // if (getNComponents() > 0)
    //   os << std::endl;
  //   UiCallback::setNComponents(n);
  // }
}
