#ifndef SLMOTION_CLICALLBACK
#define SLMOTION_CLICALLBACK

#include "UiCallback.hpp"

namespace slmotion {
  /**
   * This class is used as UiCallback for a very simple CLI
   * implementation (ie. just print to the stream)
   */
  class CliCallback : public UiCallback {
  public:
    explicit CliCallback(std::ostream& ostream) : os(ostream), 
                                                  maxLineLength(0),
                                                  lastSeenComponentIndex(0)
    {}

    virtual ~CliCallback() {}

    CliCallback(const CliCallback&) = delete;
    CliCallback& operator=(const CliCallback&) = delete;

    virtual bool operator()(double percentComplete);

    // virtual void setNComponents(size_t n);

  private:
    std::ostream& os;
    size_t maxLineLength; // the maximal length of a line encountered
    size_t lastSeenComponentIndex; // to keep track of when to print newlines
  };
}

#endif
