#ifndef SLMOTION_COLOUR_SPACE_CONVERTER
#define SLMOTION_COLOUR_SPACE_CONVERTER

#include <string>
#include "Component.hpp"
#include "ColourSpace.hpp"

namespace slmotion {
  /**
   * Black board entry for greyscale images
   */
  const std::string COLOURSPACECONVERTER_BLACKBOARD_GSIMAGE_ENTRY = "gsimage";
  // cv::Mat

  /**
   * This is a component that simply eats frames and outputs the same 
   * content in a different colour space.
   */
  class ColourSpaceConverter : public Component {
  public:
    explicit ColourSpaceConverter(bool) : Component(true) {}



    virtual std::string getShortDescription() const {
      return "Converts input frames into some other colour space";
    }

    virtual std::string getLongDescription() const {
      return "Converts input frames into some other colour space";
    }

    virtual property_set_t getRequirements() const {
      return property_set_t();
    }

    virtual std::string getShortName() const {
      return "ColourSpaceConverter";
    }

    virtual void reset() { }

    virtual boost::program_options::options_description getConfigurationFileOptionsDescription() const;

    ColourSpaceConverter(BlackBoard* blackBoard, FrameSource* frameSource,
                         const std::string& blackBoardEntry = COLOURSPACECONVERTER_BLACKBOARD_GSIMAGE_ENTRY,
                         const ColourSpace& colourSpace = *ColourSpace::GREY) :
      Component(blackBoard, frameSource), colourSpace(colourSpace.clone()),
      blackBoardEntry(blackBoardEntry) { }

    ColourSpaceConverter(const ColourSpaceConverter& other) = default;
    ColourSpaceConverter& operator=(const ColourSpaceConverter& other) = default;

    virtual std::string getComponentName() const {
      return "Colour space converter";
    }

    /**
     * Performs the colour space conversion, stores the result on the black 
     * board
     */
    virtual void process(frame_number_t frameNumber);



    inline virtual property_set_t getProvided() const {
      return property_set_t { COLOURSPACECONVERTER_BLACKBOARD_GSIMAGE_ENTRY };
    }


    virtual boost::program_options::options_description getCommandLineOptionsDescription() const {
      return boost::program_options::options_description();
    }



  private:
    virtual Component* createComponentImpl(const boost::program_options::variables_map&, BlackBoard* blackBoard, FrameSource* frameSource) const;

    std::shared_ptr<ColourSpace> colourSpace;
    std::string blackBoardEntry;
  };
}

#endif
