#ifndef SLMOTION_DUMMY_FRAME_SOURCE
#define SLMOTION_DUMMY_FRAME_SOURCE
#include "FrameSource.hpp"


namespace slmotion {
  /**
   * This is a dummy class: the class implements the FrameSource
   * interface, but does not do anything. It can be used for passing
   * as a necessary argument when instantiating components.
   */
  class DummyFrameSource : public FrameSource {
  public:
    DummyFrameSource();

    ~DummyFrameSource() {}

    inline frame_number_type size() const {
      return 0;
    }

    const cv::Mat& operator[](frame_number_type) {
      throw std::out_of_range("Operation not supported: dummy class");
      const static cv::Mat dummy;
      return dummy;
    }

    inline double getFps() const {
      return 0;
    }
  };
}
#endif
