#include "SkinDetector.hpp"
#include "FaceOcclusionDetector.hpp"
#include "PropagationSkinDetector.hpp"
#include "TrackingSkinDetector.hpp"

using cv::Mat;
using cv::Rect;
using cv::Point;
using cv::Vec3b;
using cv::Scalar;
using cv::Point2f;
using std::string;
using std::map;
using std::set;
using std::cout;
using std::endl;
using std::pair;
using std::vector;

namespace slmotion {

  static FaceOcclusionDetector DUMMY(true);

  bool FaceOcclusionDetector::processRangeImplementation(frame_number_t first,
				  frame_number_t last,
                                                UiCallback* /* uiCallback */){
    
   localBlackBoardType localbb; 

   // subsequent analysis requires the following information to
   // be put on the local blackboard:

   // frames
   // face detection results
   // skin detection mask

   // old-fashioned blackboard for local info storage

   for(frame_number_t n=first;n<last;n++){
     // const cv::Mat& inFrame = getFrameSource()[n];
     // const cv::Mat& mask = getBlackBoard().get<cv::Mat>(n, SKINDETECTOR_BLACKBOARD_MASK_ENTRY);
      
     if (!getBlackBoard().has(n, FACEDETECTOR_BLACKBOARD_ENTRY)) 
      throw SLMotionException("No face data on the black board!");

     cv::Rect faceLocation = *getBlackBoard().get<cv::Rect>(n, FACEDETECTOR_BLACKBOARD_ENTRY);
      localbb[std::pair<int,std::string>(n,"frame")]=getFrameSource()[n];
      localbb[std::pair<int,std::string>(n,"skinmask")]=getBlackBoard().get<cv::Mat>(n, SKINDETECTOR_BLACKBOARD_MASK_ENTRY);
      localbb[std::pair<int,std::string>(n,"facerect")]=faceLocation;

   }


   if(last>first){



     // prepare for occlusion tracking by placing necessary 
     // results to blackboard

     // determine the head area constraint masks for each frame and place on blackboard

     // this could be better done based on facial landmarks

     int cols,rows;

     for(int f=first;f<(int)last;f++){

       Mat frame=*boost::any_cast<cv::Mat>(&localbb[std::pair<int,std::string>(f,"frame")]);

       cols=frame.cols;
       rows=frame.rows;

       Mat  skinmask=*boost::any_cast<cv::Mat>(&localbb[std::pair<int,std::string>(f,"skinmask")]);
       
       Rect faceLocation=*boost::any_cast<cv::Rect>(&localbb[std::pair<int,std::string>(f,"facerect")]);
       
       localbb[std::pair<int,std::string>(f,"headconstraintmask")]=Mat(frame.rows,frame.cols,CV_8UC1,cv::Scalar::all(0));
       
       Mat cmask=*boost::any_cast<cv::Mat>(&localbb[std::pair<int,std::string>(f,"headconstraintmask")]);
    
       if(localbb.count(std::pair<int,std::string>(f,"uniqueblobmask"))==0){
	 localbb[std::pair<int,std::string>(f,"uniqueblobmask")]=Mat();
	 
	 Mat ulbl;
	 labelConnectedComponents(skinmask,ulbl);
	 localbb[std::pair<int,std::string>(f,"uniqueblobmask")]=ulbl;
	
       }	     

       Mat ulbl=*boost::any_cast<cv::Mat>(&localbb[std::pair<int,std::string>(f,"uniqueblobmask")]);

       uchar facelbl=ulbl.at<uchar>(faceLocation.y+0.5*faceLocation.height,
				    faceLocation.x+0.5*faceLocation.width);
       for(int x=0;x<frame.cols;x++)
	 for(int y=0;y<frame.rows;y++){
	   if(x>faceLocation.x-0.4*faceLocation.width &&
	      x<faceLocation.x+1.4*faceLocation.width &&
	      y>faceLocation.y-0.3*faceLocation.height &&
	      y<faceLocation.y+1.3*faceLocation.height &&
	      skinmask.at<uchar>(y,x)!=0){

	     uchar lbl=ulbl.at<uchar>(y,x);
	  
	     if(lbl==facelbl){
	       cmask.at<uchar>(y,x)=255;
	     }
	   }
	 }

       
     }


     recordHeadAreaCorrespondence(first,last,"headconstraintmask",
				  "displacementfield",
				  "templatematcherrorfield",
				  "displacementdiscontinuityfield",
				  "templatematchmoderrorfield",
				  "headareaint_e",
				  "headareaint_d",
				  "headareaint_me",
				  localbb);

     for(int f=first+1;f<(int)last;f++){
       Mat frame=*boost::any_cast<cv::Mat>(&localbb[std::pair<int,std::string>(f,"frame")]);
       Mat cmask=*boost::any_cast<cv::Mat>(&localbb[std::pair<int,std::string>(f,"headconstraintmask")]);

       Mat prevframe=*boost::any_cast<cv::Mat>(&localbb[std::pair<int,std::string>(f-1,"frame")]);

       Mat efield=*boost::any_cast<cv::Mat>(&localbb[std::pair<int,std::string>(f,"templatematcherrorfield")]);

       Mat mefield=*boost::any_cast<cv::Mat>(&localbb[std::pair<int,std::string>(f,"templatematchmoderrorfield")]);

       Mat dfield=*boost::any_cast<cv::Mat>(&localbb[std::pair<int,std::string>(f,"displacementdiscontinuityfield")]);


//        float eint=*boost::any_cast<float>(&localbb[std::pair<int,std::string>(f,"headareaint_e")]);

        float meint=*boost::any_cast<float>(&localbb[std::pair<int,std::string>(f,"headareaint_me")]);

	//       float dint=*boost::any_cast<float>(&localbb[std::pair<int,std::string>(f,"headareaint_d")]);
       

     //   cv::imshow("frame",frame);
//        floatimagesc("error",efield);
//        floatimagesc("discontinuity",dfield);
//        floatimagesc("mod. error",mefield);

//        cout << "integrated errors: eint=" << eint << " meint="<<meint<<" dint="<<dint<<endl;

       float framethreshold=3e6;


       Mat visframe=frame.clone();
       float maxerr=0;

       Mat occlmask(frame.rows,frame.cols,CV_8UC1,cv::Scalar::all(0));

       for(int x=0;x<frame.cols;x++)
	 for(int y=0;y<frame.rows;y++){
	   visframe.at<Vec3b>(y,x)[0]=0;
	   maxerr=fmax(maxerr,mefield.at<float>(y,x));
	 }

       
       if(meint>framethreshold){
	 float pixthr=maxerr*0.25*framethreshold/meint;

	 for(int x=0;x<frame.cols;x++)
	   for(int y=0;y<frame.rows;y++)
	     if(mefield.at<float>(y,x)>pixthr){
	       visframe.at<Vec3b>(y,x)[0]=255;
	       occlmask.at<uchar>(y,x)=255;
	     }
	 
       }

       getBlackBoard().set(f, FACEOCCLUSIONDETECTOR_BLACKBOARD_MASK_ENTRY, 
			   occlmask);

     //   cv::imshow("probable occluded area",visframe);
//        cv::waitKey(0); 


     }
     
     Mat occlmask(rows,cols,CV_8UC1,cv::Scalar::all(0));
     getBlackBoard().set(first, FACEOCCLUSIONDETECTOR_BLACKBOARD_MASK_ENTRY, 
			 occlmask);



   }

   return true;


  }

  Component* FaceOcclusionDetector::createComponentImpl(const boost::program_options::variables_map&, BlackBoard* blackBoard, FrameSource* frameSource) const {
    return new FaceOcclusionDetector(blackBoard, frameSource);
  }


}



