#ifndef SLMOTION_FEATURE_VECTORS
#define SLMOTION_FEATURE_VECTORS

#include <cstddef>
#include <vector>
#include <deque>
#include "opencv.hpp"

namespace slmotion {
    /**
   * A simple struct to hold various feature vectors; this solution may 
   * need to be revised
   */
  struct FeatureVectors {
    FeatureVectors(size_t size) :
      totalMotionDescriptors(size, cv::Vec6d::all(0)),
      netHeadMotionDescriptors(size, cv::Vec6d::all(0)),
      netLeftHandMotionDescriptors(size, cv::Vec6d::all(0)),
      netRightHandMotionDescriptors(size, cv::Vec6d::all(0)),
      grossHeadMotionDescriptors(size, cv::Vec6d::all(0)),
      grossLeftHandMotionDescriptors(size, cv::Vec6d::all(0)),
      grossRightHandMotionDescriptors(size, cv::Vec6d::all(0))
    {}


    std::vector<cv::Vec6d> totalMotionDescriptors;
    std::vector<cv::Vec6d> netHeadMotionDescriptors;
    std::vector<cv::Vec6d> netLeftHandMotionDescriptors;
    std::vector<cv::Vec6d> netRightHandMotionDescriptors;
    std::vector<cv::Vec6d> grossHeadMotionDescriptors;
    std::vector<cv::Vec6d> grossLeftHandMotionDescriptors;
    std::vector<cv::Vec6d> grossRightHandMotionDescriptors;
      
    std::deque < cv::Vec<double, 7> > orientationMotionDescriptors;
    std::deque < cv::Vec<double, 10> > centroidMotionDescriptors;       
  };
}

#endif
