#ifndef SLMOTION_GAUSSIAN_FOREGROUND_CLASSIFIER
#define SLMOTION_GAUSSIAN_FOREGROUND_CLASSIFIER

#include "BinaryClassifier.hpp"
#include <opencv2/opencv.hpp>

namespace slmotion {
  class GaussianForegroundClassifier : public BinaryClassifier {

  public:

    virtual void train(const std::vector<std::vector<float> > &negSamples,
		       const std::vector<std::vector<float> > &posSamples,
		       const std::vector<bool> *dimMask=NULL,
		       const std::vector<float> *negWeights=NULL,
		       const std::vector<float> *posWeights=NULL);

    virtual float predict(const std::vector<float>  &sample,
			  const std::vector<bool> *dimMask=NULL);

    cv::Mat inverseCovariance; /// Inverse covariance matrices
    cv::Mat mean; ///< Colour cluster means
    double covDetSqrt; ///< Square roots of covariance matrix determinants

    std::map<std::vector<float>,float> predictioncache;
  };
}
#endif
