#include "GaussianMixture.hpp"

namespace slmotion {
  GaussianMixture::GaussianMixture(const std::vector<cv::Mat>& samples) {
    int nVars = samples.size() > 0 ? samples.front().cols : 0;
    for (auto it = samples.cbegin(); it != samples.cend(); ++it)
      if (it->cols != nVars)
        throw std::invalid_argument("Tried to initialise a Gaussian mixture"
                                    " with an inconsistent number of "
                                    "variables among clusters.");

    weights = std::vector<double>(samples.size());

    // compute total number of samples
    size_t samplesTotal = 0;
    for (size_t k = 0; k < samples.size(); ++k)
      samplesTotal += samples[k].rows;

    // set weights for each distribution
    for (size_t k = 0; k < samples.size(); ++k) 
      weights[k] = static_cast<double>(samples[k].rows) /
        static_cast<double>(samplesTotal);
    

    assert(gaussians.size() == 0);
    for (size_t i = 0; i < samples.size(); ++i) 
      gaussians.push_back(Gaussian(samples[i]));
    

    assert(gaussians.size() == samples.size());
  }
}
