#ifndef SLMOTION_GRAPHICAL_BLACKBOARD_EDITOR
#define SLMOTION_GRAPHICAL_BLACKBOARD_EDITOR

#ifdef SLMOTION_WITH_GTK

#include "SingletonWindow.hpp"
#include "GraphicalStringSheet.hpp"
#include "BlackBoard.hpp"
#include <gtk/gtk.h>
#include <memory>
#include <gdk/gdk.h>

namespace slmotion {
  namespace gui {
    /**
     * This class works as a graphical black board editor which allows
     * the user to view and manipulate the content of the blackboard
     */
    class GraphicalBlackBoardEditor : public SingletonWindow {
    public:
      explicit GraphicalBlackBoardEditor(SingletonWindow** pointer,
                                         std::shared_ptr<BlackBoard> bb);

      virtual ~GraphicalBlackBoardEditor();

    private:
      struct SelectionParams {
        int propertyColumn;
        int frameNumberColumn;
        int typeColumn;
        GtkTreeIter currentRow;
        GraphicalBlackBoardEditor* editor;
      };



      static gboolean selectCallback(GtkTreeSelection*,
                                     GtkTreeModel* model,
                                     GtkTreePath* path,
                                     gboolean,
                                     gpointer data);



      void init();
      
      std::shared_ptr<BlackBoard> blackboard;
      GraphicalStringSheet gss;
      GtkTextBuffer* textBuffer;
      GtkTextView* textView;
      SelectionParams sp;
      GtkImage* imageBox;
      GdkPixbuf* pixBuf;
    };
  }
}

#endif // SLMOTION_WITH_GTK
#endif
