#ifdef SLMOTION_WITH_GTK
#include "GraphicalStringSheet.hpp"
#include "GuiException.hpp"
#include <vector>
#include <iostream>

namespace slmotion {
  namespace gui {
    GraphicalStringSheet::GraphicalStringSheet() :
      scrolledWindow(gtk_scrolled_window_new(nullptr, nullptr)),
      treeView(GTK_TREE_VIEW(gtk_tree_view_new())),
      nColumns(0),
      model(nullptr) {
      gtk_container_add(GTK_CONTAINER(scrolledWindow), 
                        GTK_WIDGET(treeView));
      gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scrolledWindow),
                                     GTK_POLICY_AUTOMATIC, 
                                     GTK_POLICY_AUTOMATIC);
    }



    void GraphicalStringSheet::addRow(const std::vector<std::string>& text) {
      if (text.size() != static_cast<size_t>(nColumns))
        throw GuiException("Column number mismatch");

      GtkTreeIter iter;
      gtk_list_store_append(model, &iter);
      char *c1, *c2, *c3;
      c1 = new char[text[0].length() + 1];
      c2 = new char[text[1].length() + 1];
      c3 = new char[text[2].length() + 1];
      strcpy(c1, text[0].c_str());
      strcpy(c2, text[1].c_str());
      strcpy(c3, text[2].c_str());
      gtk_list_store_set(model, &iter, 0, c1, 1, c2, 2, c3, -1);
      delete[] c1;
      delete[] c2;
      delete[] c3;
#if 0
      std::vector<GValue> gvalues(text.size());
      std::vector<gint> cols(text.size());
      memset(&gvalues[0], 0, sizeof(GValue)*gvalues.size());

      for (size_t i = 0; i < text.size(); ++i) {
        g_value_init(&gvalues[i], G_TYPE_STRING);
        g_value_set_string(&gvalues[i], text[i].c_str());
        cols[i] = i;
      }

      GtkTreeIter iter;
      gtk_list_store_append(model, &iter);
      gtk_list_store_set_valuesv(model, &iter, &cols[0], &gvalues[0], 
                                 text.size());
#endif
    }



    void GraphicalStringSheet::createModel() {
      std::vector<GType> types(nColumns, G_TYPE_STRING);
      model = gtk_list_store_newv(nColumns, &types[0]);
      gtk_tree_view_set_model(treeView, GTK_TREE_MODEL(model));
    }



    int GraphicalStringSheet::addColumn(const std::string& name) {
      if (model != nullptr)
        throw GuiException("Cannot add a column to a sheet with a model!");

      GtkCellRenderer *renderer = gtk_cell_renderer_text_new();
      GtkTreeViewColumn* column = gtk_tree_view_column_new();
      gtk_tree_view_column_set_title(column, name.c_str());
      gtk_tree_view_column_pack_start(column, renderer, true);
      gtk_tree_view_column_add_attribute(column, renderer, "text", nColumns);
      gtk_tree_view_append_column(treeView, column);
      return nColumns++;
    }
  }
}
#endif
