#ifndef SLMOTION_HAND_LOCATOR
#define SLMOTION_HAND_LOCATOR

#include "BlobExtractor.hpp"
#include "FaceDetector.hpp"

namespace slmotion {
  // cv::Rect
  const std::string HANDLOCATOR_BLACKBOARD_ENTRY = "handlocation";

  /**
   * Attempts to locate the bounding box of the hand on the basis of
   * skin blobs detected
   */
  class HandLocator : public Component {
  public:
    HandLocator(bool) : Component(true) { }

    HandLocator(BlackBoard* blackBoard, FrameSource* frameSource, int padding = 0,
                bool mirror = false) :
      Component(blackBoard, frameSource), padding(padding), mirror(mirror) { }

    virtual void process(frame_number_t frameNumber);

    virtual std::string getShortDescription() const {
      return "Hand Locator";
    }

    virtual std::string getLongDescription() const {
      return "Locates the bouding box of the hand";
    }

    virtual property_set_t getRequirements() const {
      return property_set_t { FACEDETECTOR_BLACKBOARD_ENTRY, 
          BLACKBOARD_BLOBS_ENTRY };
    }

    virtual property_set_t getProvided() const {
      return property_set_t { HANDLOCATOR_BLACKBOARD_ENTRY };
    }

    virtual std::string getShortName() const {
      return "HandLocator";
    }

    virtual std::string getComponentName() const {
      return "Hand Locator";
    }

    virtual void reset() {
    }

    virtual boost::program_options::options_description getConfigurationFileOptionsDescription() const;

    virtual boost::program_options::options_description getCommandLineOptionsDescription() const {
      return boost::program_options::options_description();
    }

  private:
    virtual Component* createComponentImpl(const boost::program_options::variables_map& configuration, BlackBoard* blackBoard, FrameSource* frameSource) const;

    int padding;
    bool mirror;
  };
}

#endif

