#ifndef SLMOTION_HEAD_POSE
#define SLMOTION_HEAD_POSE

#include "Component.hpp"

// This is a dummy component file that can be used as a template for 
// creating actual useful components

namespace slmotion {
  const std::string HEAD_POSE_BLACKBOARD_ENTRY = "headpose";

  class HeadPose : public Component {
  public:
    HeadPose(bool) : Component(true) { }

    HeadPose(BlackBoard* blackBoard, FrameSource* frameSource) :
      Component(blackBoard, frameSource) { }

    virtual void process(frame_number_t frameNumber);

    virtual std::string getShortDescription() const {
      return "Dummy component";
    }

    virtual std::string getLongDescription() const {
      return "Dummy configuration file help text";
    }

    virtual property_set_t getRequirements() const {
      return property_set_t();
    }

    virtual property_set_t getProvided() const {
      return property_set_t();
    }

    virtual std::string getShortName() const {
      return "HeadPose";
    }

    virtual std::string getComponentName() const {
      return "Head Pose Component";
    }

    virtual void reset() {
    }

    virtual boost::program_options::options_description getConfigurationFileOptionsDescription() const {
      return boost::program_options::options_description();
    }

    virtual boost::program_options::options_description getCommandLineOptionsDescription() const {
      return boost::program_options::options_description();
    }

  private:
    virtual Component* createComponentImpl(const boost::program_options::variables_map& configuration, BlackBoard* blackBoard, FrameSource* frameSource) const;
  };
}

#endif

