#ifndef SLMOTION_HEAD_POSE
#define SLMOTION_HEAD_POSE

#ifdef SLMOTION_WITH_LIBSVM

#include "Component.hpp"
#include "util.hpp"
#include "RuleSkinDetector.hpp"
#include "FacialLandmarkDetector.hpp"
#include "FaceDetector.hpp"
#include <SVM.h>


namespace slmotion {
  const std::string DEFAULT_YAW_MODEL = getInstallPrefix()+"/share/slmotion/models/hpe_yaw.model";
  const std::string DEFAULT_PIT_MODEL = getInstallPrefix()+"/share/slmotion/models/hpe_pitch.model";
  const std::string DEFAULT_YAW_FILTER = "0.131232876230957,  0.131233739713927, 0.131234171456691, 0.131234171456691, 0.131233739713927, 0.131232876230957";
  const std::string DEFAULT_PIT_FILTER = "0.103434515739815,  0.103519658649884, 0.103570764570074, 0.103587803239874, 0.103570764570074, 0.103519658649884, 0.103434515739815";
  const std::string DEFAULT_ROL_FILTER = "0.193353146053392,  0.203303529012766, 0.206686649867683, 0.203303529012766, 0.193353146053392";
  const std::string HEAD_POSE_BLACKBOARD_ENTRY = "headpose";
  const bool DEFAULT_NATIVE_PRECISION = true;

  struct svm_model* getSvmModel(std::string m);

  class HeadPoseEstimator : public Component {
  public:
    HeadPoseEstimator(bool) : Component(true) { }

    HeadPoseEstimator(BlackBoard* blackBoard, FrameSource* frameSource) : 
      Component(blackBoard, frameSource),
      yawModel(DEFAULT_YAW_MODEL),
      pitModel(DEFAULT_PIT_MODEL),
      yawFilter(DEFAULT_YAW_FILTER),
      pitFilter(DEFAULT_PIT_FILTER),
      rolFilter(DEFAULT_ROL_FILTER),
      nativePrecision(DEFAULT_NATIVE_PRECISION),
      svmYawModel(getSvmModel(yawModel)),
      svmPitModel(getSvmModel(pitModel)) {
    }

    HeadPoseEstimator& operator=(const HeadPoseEstimator&) = delete;
    virtual ~HeadPoseEstimator(); 

    virtual void process(frame_number_t frameNumber);

    inline void setYawModel(std::string x) {
      yawModel = x;
    }

    inline void setPitModel(std::string x) {
      pitModel = x;
    }

    inline void setYawFilter(std::string x) {
      yawFilter = x;
    }

    inline void setPitFilter(std::string x) {
      pitFilter = x;
    }

    inline void setRolFilter(std::string x) {
      rolFilter = x;
    }

    inline void setNativePrecision(bool x) {
      nativePrecision = x;
    }

    virtual std::string getShortDescription() const {
      return "Head pose estimator";
    }

    virtual std::string getLongDescription() const {
      return "Estimates the pose of the head (yaw, pitch, roll) from a set of facial landmarks and a skin mask.";
    }

    virtual property_set_t getRequirements() const;

    virtual property_set_t getProvided() const {
      return property_set_t();
    }

    virtual std::string getShortName() const {
      return "HeadPoseEstimator";
    }

    virtual std::string getComponentName() const {
      return "Head Pose Estimator";
    }

    virtual void reset() {
    }

    virtual boost::program_options::options_description getConfigurationFileOptionsDescription() const;

    virtual boost::program_options::options_description getCommandLineOptionsDescription() const {
      return boost::program_options::options_description();
    }

  private:
    virtual Component* createComponentImpl(const boost::program_options::variables_map& configuration, BlackBoard* blackBoard, FrameSource* frameSource) const;
    std::string yawModel;  // file name of the svm yaw model
    std::string pitModel;  // file name of the svm yaw model
    std::string yawFilter;
    std::string pitFilter;
    std::string rolFilter;
    bool nativePrecision;
    struct svm_model* svmYawModel;
    struct svm_model* svmPitModel;

    virtual bool processRangeImplementation(frame_number_t first, frame_number_t last, UiCallback* uiCallback);

  };
}

#endif // SLMOTION_WITH_LIBSVM

#endif
