#include <boost/lexical_cast.hpp>
#include "ImageSequenceSource.hpp"

using cv::Mat;
using boost::lexical_cast;
using cv::imread;
using std::string;

namespace slmotion {
  Mat ImageSequenceSource::getFrame(size_t frameNumber) {
    if (frameNumber > filenames.size())
      throw std::out_of_range("Given frame number (" +
                              lexical_cast<string>(frameNumber) + 
                              ") exceeds the number of filenames (" +
                              lexical_cast<string>(filenames.size()) + 
                              ")");
    current_file_number = frameNumber;

    return imread(filenames[frameNumber]);
  }



  const cv::Mat& ImageSequenceSource::operator[](frame_number_type frameNumber) {
    if (frameInCache(frameNumber))
      return getFrameFromCache(frameNumber);

    cacheFrame(frameNumber, getFrame(frameNumber));
    return getFrameFromCache(frameNumber);
  }
}
