#ifndef SLMOTION_MAIN_WINDOW
#define SLMOTION_MAIN_WINDOW

#include "ConfigurationWindow.hpp"
#include "BlackBoard.hpp"

#ifdef SLMOTION_WITH_QT
#include <QMainWindow>
#include <QListView>
#include <QLineEdit>
#include <QPushButton>
#include <QLabel>
#endif // SLMOTION_WITH_QT

namespace slmotion {
  namespace gui {
#ifdef SLMOTION_WITH_GTK
      struct Params;
#endif // SLMOTION_WITH_GTK

    /**
     * This class represents the main window
     */
#ifdef SLMOTION_WITH_QT
    class MainWindow : public QMainWindow 
#else // SLMOTION_WITH_QT
    class MainWindow 
#endif // SLMOTION_WITH_QT
    {
#ifdef SLMOTION_WITH_QT
      Q_OBJECT
#endif // SLMOTION_WITH_QT
    public:

      /**
       * Constructs a window with the given title
       */
      MainWindow(const std::string& title);



      ~MainWindow();
      MainWindow(const MainWindow&) = delete;
      MainWindow& operator=(const MainWindow&) = delete;
      MainWindow(MainWindow&&) = delete;
      MainWindow& operator=(MainWindow&&) = delete;

      int exec(int argc, char* argv[]);



      inline bool getShouldQuit() const {
        return shouldQuit;
      }



#if defined(SLMOTION_WITH_GTK)
      inline void setShouldQuit(bool b) {
        shouldQuit = b;
      }



      inline Params& getParams() {
        return *params;
      }



      inline Params* getParamsPtr() {
        return params;
      }
#elif defined(SLMOTION_WITH_QT)
      void setStatusBarText(const std::string& text);
#endif // SLMOTION_WITH_QT



#ifdef SLMOTION_WITH_QT
    private slots:
      void showAboutBox();
      void showConfigureWindow();
      void removeCurrentInputFile();
      void addInputFile();
      void selectScriptFile();
      void selectAnnotationTemplateFile();
      void selectOutVideoFile();
      void selectOutCsvFile();
      void selectOutElanFile();
      void getCmdOpts();
      void process();
      void loadBlackBoardDump();
      void saveBlackBoardDump();

    private:
      std::vector<std::string> generateCmdOpts() const;
#endif // SLMOTION_WITH_QT



    private:
      std::string title;
      bool shouldQuit;
#if defined(SLMOTION_WITH_QT)
      bool processing; // if true, process is underway and "cancel" should be displayed on the "process" button
      std::string conffile;
      ConfigurationWindow* confWin;
      QListView inputFilesListView;
      QLineEdit scriptFileEdit;
      QLineEdit annotationTemplateFileEdit;
      QLineEdit outVideoFileEdit;
      QLineEdit outCsvFileEdit;
      QLineEdit outElanFileEdit;
      QPushButton processButton;
      QLabel statusBarMessage;
      std::string argv0;
      std::shared_ptr<BlackBoard> blackBoard;
      QCheckBox emptyBlackBoardCheckBox;
#elif defined(SLMOTION_WITH_GTK)
      Params* params;
#endif // SLMOTION_WITH_GTK
    };



    /**
     * Executes the program. The return value corresponds to what
     * main is expected to return (ie. 0 on success).
     */
    int exec(int argc, char* argv[]);
  }
}

#endif
