#ifndef SLMOTION_MEMORY_STREAM
#define SLMOTION_MEMORY_STREAM

#include <cstdio>
#include <vector>
#include <cstdlib>

namespace slmotion {
  /**
   * The MemoryStream is an abstraction class that can be used to store data 
   * through a standard C FILE pointer into an array of data 
   */
  class MemoryStream {
  public:
    operator FILE*() {
      return filePtr;
    }

    std::vector<char> getData() const {
      return std::vector<char>(begin(), end());
    }


#ifdef __APPLE__
  public:
    MemoryStream() :
      filePtr(fwopen(&this->buffer, &writefn)) {}

    ~MemoryStream() {
      fclose(filePtr);
    }

  private:
    // MacOS X does not define open_memstream; fwopen should be used instead,
    // so this is the associated helper function
    static int writefn(void* memtemp, const char* data, int size) {
      std::vector<char>& vec = *((std::vector<char>*)memtemp);
      vec.insert(vec.end(), data, data+size);
      return size;
    }

    
    const char* begin() const {
      return &buffer[0];
    }

    const char* end() const {
      return &buffer[0] + buffer.size();
    }

    std::vector<char> buffer;

#else // __APPLE__
  public:
    MemoryStream() :
      memdata(NULL), len(0),
      filePtr(open_memstream(&memdata, &len)) {}

    ~MemoryStream() {
      fclose(filePtr);
      free(memdata);
    }

  private:
    const char* begin() const {
      return memdata;
    }

    const char* end() const {
      return memdata + len;
    }

    char* memdata;
    size_t len;
#endif // __APPLE__
    FILE* filePtr;
  };
}
#endif
