#ifdef SLMOTION_ENABLE_LIBFLANDMARK
#include "MultiFacialLandmarkDetector.hpp"
#include "RawFaceDetector.hpp"

namespace slmotion {
  extern int debug;
  static MultiFacialLandmarkDetector DUMMY(true);

  extern BlackBoard* vvi_blackBoard;
  extern FrameSource* vvi_frameSource;



  MultiFacialLandmarkDetector::~MultiFacialLandmarkDetector() {
  }



  Component::property_set_t MultiFacialLandmarkDetector::getRequirements() const {
    return property_set_t { FACEDETECTOR_RAW_FACE_VECTOR_BLACKBOARD_ENTRY };
  }



  void MultiFacialLandmarkDetector::process(frame_number_t frnumber) {
    cv::Mat inFrame = getFrameSource()[frnumber];
    BlackBoardPointer<std::vector<cv::Rect> > facesPtr = 
      getBlackBoard().get<std::vector<cv::Rect>>(frnumber, 
                                                 FACEDETECTOR_RAW_FACE_VECTOR_BLACKBOARD_ENTRY);
    std::vector<cv::Rect>& faces = *facesPtr; 

    std::vector<std::vector<cv::Point2f>> landmarks;
    for (const cv::Rect& face : faces)
      landmarks.push_back(getPointsForFace(face, inFrame));

    getBlackBoard().set(frnumber, MULTI_FACIAL_LANDMARK_BLACKBOARD_ENTRY, landmarks);
  }



  Component* MultiFacialLandmarkDetector::createComponentImpl(const boost::program_options::variables_map&,
                                                              BlackBoard* blackBoard,
                                                              FrameSource* frameSource) const {
    return new MultiFacialLandmarkDetector(blackBoard, frameSource);
  }

  Component::property_set_t MultiFacialLandmarkDetector::getProvided() const {
    return property_set_t { MULTI_FACIAL_LANDMARK_BLACKBOARD_ENTRY };
  }
}
#endif
