#include "SkinDetector.hpp"

namespace slmotion {
  /**
   * A simple wrapper for the OpenCV adaptive skin detector to make it
   * compatible with slmotion skin detection classes
   */
  class OpenCvAdaptiveSkinDetector : public SkinDetector {
  public:
    /**
     * Creates the skin detector and initialises the CvAdaptiveSkinDetector
     * using the given parameters. The parameters are specified exactly as in
     * CvAdaptiveSkinDetector class.
     */
    OpenCvAdaptiveSkinDetector(BlackBoard* blackBoard, 
                               FrameSource* frameSource,
                               int samplingDivider = 1,
                               int morphingMethod =
                               CvAdaptiveSkinDetector::MORPHING_METHOD_NONE) :
      SkinDetector(blackBoard, frameSource, *ColourSpace::BGR),
      adaptiveSkinDetector(samplingDivider, morphingMethod) { }



    // std::string findParameters(const cv::Mat& validImage,
    //                            const cv::Mat& validMask,
    //                            double fpCost = 1, double fnCost = 1)*

    std::string findParameters(const cv::Mat&, const cv::Mat&, double = 1, 
                               double = 1) {
      // This function should not be called as it has not been implemented
      // yet. This should catch attention.
      assert(false);
    }



    
    virtual std::string getShortDescription() const {
      return "OpenCV adaptive skin detector";
    }

    virtual std::string getLongDescription() const {
      return "OpenCV adaptive skin detector";
    }

    virtual slmotion::Component::property_set_t getRequirements() const {
      return slmotion::Component::property_set_t();
    }

    virtual std::string getShortName() const {
      return "AdaptiveSkinDetector";
    }

    virtual std::string getComponentName() const {
      return "Adaptive Skin Detector";
    }


    OpenCvAdaptiveSkinDetector(bool) : SkinDetector(true) {}

    OpenCvAdaptiveSkinDetector(const boost::program_options::variables_map& configuration, BlackBoard* blackBoard, FrameSource* frameSource);

    virtual boost::program_options::options_description getCommandLineOptionsDescription() const {
      return boost::program_options::options_description();
    }

  private:
    virtual slmotion::Component* createComponentImpl(const boost::program_options::variables_map& configuration, slmotion::BlackBoard* blackBoard, slmotion::FrameSource* frameSource) const {
      return new OpenCvAdaptiveSkinDetector(configuration, blackBoard, frameSource);
    }



    inline void detect(const cv::Mat& inFrame, cv::Mat& outMask) {
      IplImage inFrameTemp = inFrame;
      IplImage outMaskTemp = outMask;
      adaptiveSkinDetector.process(&inFrameTemp, &outMaskTemp);
      threshold(outMask, outMask, 1, 256, cv::THRESH_BINARY);
    }

    CvAdaptiveSkinDetector adaptiveSkinDetector;
  };
}

