#ifdef SLMOTION_ENABLE_LIBFLANDMARK
#include "SkinDetector.hpp"
#include "POAAnnotationAid.hpp"
#include "PropagationSkinDetector.hpp"
#include "TrackingSkinDetector.hpp"
#include "FaceOcclusionDetector.hpp"
#include "FacialLandmarkDetector.hpp"
#include "FaceOcclusionDetector.hpp"
#include "BlobExtractor.hpp"
#include "BodyPartCollector.hpp"
#include "FaceSuviSegmentator.hpp"

using cv::Mat;
using cv::Rect;
using cv::Point;
using cv::Vec3b;
using cv::Scalar;
using cv::Point2f;
using std::string;
using std::map;
using std::set;
using std::cout;
using std::endl;
using std::pair;
using std::vector;

namespace slmotion {


  static POAAnnotationAid DUMMY(true);

  bool POAAnnotationAid::processRangeImplementation(frame_number_t first,
				  frame_number_t last,
                                                UiCallback* /* uiCallback */){

    vector<Vec3b> col(8);

    col[0]=Vec3b(255,255,255);
    col[1]=Vec3b(255,255,0);
    col[2]=Vec3b(255,0,255);
    col[3]=Vec3b(0,255,255);
    col[4]=Vec3b(255,0,0);
    col[5]=Vec3b(0,0,0);
    col[6]=Vec3b(0,0,255);
    col[7]=Vec3b(0,128,255);

   for(frame_number_t n=first;n<last;n++){
     Mat visframe = getFrameSource()[n].clone();

     if(getBlackBoard().has(n, FACESUVISEGMENTS_BLACKBOARD_ENTRY)){
       BlackBoardPointer<Mat> suvimap=getBlackBoard().get<cv::Mat>(n, FACESUVISEGMENTS_BLACKBOARD_ENTRY);

       for(int x=0;x<suvimap->cols;x++)
	 for(int y=0;y<suvimap->rows;y++)
	    switch(suvimap->at<uchar>(y,x)){
	  case static_cast<uchar>(SuviSegment::CHEEKS):
	    visframe.at<Vec3b>(y,x)=0.3*col[0]+0.7*visframe.at<Vec3b>(y,x);
	    break;
	  case static_cast<uchar>(SuviSegment::NOSE):
	    visframe.at<Vec3b>(y,x)=0.3*col[1]+0.7*visframe.at<Vec3b>(y,x);
	    break;
	  case static_cast<uchar>(SuviSegment::MOUTH):
	    visframe.at<Vec3b>(y,x)=0.3*col[2]+0.7*visframe.at<Vec3b>(y,x);
	    break;
	  case static_cast<uchar>(SuviSegment::NECK):
	    visframe.at<Vec3b>(y,x)=0.3*col[3]+0.7*visframe.at<Vec3b>(y,x);
	    break;
	  case static_cast<uchar>(SuviSegment::FOREHEAD):
	    visframe.at<Vec3b>(y,x)=0.3*col[4]+0.7*visframe.at<Vec3b>(y,x);
	    break;
	  case static_cast<uchar>(SuviSegment::OTHER):
	    visframe.at<Vec3b>(y,x)=0.3*col[5]+0.7*visframe.at<Vec3b>(y,x);
	    break;
	  }



     }

     // display the facial landmarks, if they are found on blackboard

     if(getBlackBoard().has(n, FACIAL_LANDMARK_BLACKBOARD_ENTRY)){
       BlackBoardPointer<vector<Point2f> > landmarks = 
         getBlackBoard().get<vector<cv::Point2f> >(n, FACIAL_LANDMARK_BLACKBOARD_ENTRY);

       vector<Scalar> col(8);

      col[0]=CV_RGB(255,255,255);
      col[1]=CV_RGB(255,255,0);
      col[2]=CV_RGB(255,0,255);
      col[3]=CV_RGB(0,255,255);
      col[4]=CV_RGB(255,0,0);
      col[5]=CV_RGB(0,255,0);
      col[6]=CV_RGB(0,0,255);
      col[7]=CV_RGB(0,128,255);

      for(int i=0;i<8;i++)
        cv::circle(visframe, (*landmarks)[i], 4, col[0]);
     }


     char str[80];
     sprintf(str,"frame %d",(int)n);

     putText(visframe,str,Point(0,15),  cv::FONT_HERSHEY_PLAIN, 1,CV_RGB(255,255,255));

     cv::imshow("suvi encoding",visframe);
     int k=cv::waitKey(0);

     if(k=='s')
       n +=5;
     
     if(k=='b')
       n-=2;



   }

     return true;


   }

  Component* POAAnnotationAid::createComponentImpl(const boost::program_options::variables_map&, BlackBoard* blackBoard, FrameSource* frameSource) const {
    return new POAAnnotationAid(blackBoard, frameSource);
  }
}


#endif // SLMOTION_ENABLE_LIBFLANDMARK
