#ifndef SLMOTION_PROPAGATION_SKIN_DETECTOR
#define SLMOTION_PROPAGATION_SKIN_DETECTOR

#include "SkinDetector.hpp"
#include "FaceDetector.hpp"
#include "BinaryClassifier.hpp"
#include "FeatureExtractor.hpp"

namespace slmotion {
  typedef std::map<std::pair<int,std::string>,boost::any> localBlackBoardType;

  class PropagationSkinDetector : public SkinDetector {
  public:
    explicit PropagationSkinDetector(BlackBoard* blackBoard, 
				     FrameSource* frameSource,
				     const ColourSpace& c = *ColourSpace::HSV) :
      SkinDetector(blackBoard, frameSource, c)
    { 
      cls=NULL;
      corethreshold=0.3;
      outerthreshold=0.12;
    }

    virtual ~PropagationSkinDetector(){
      delete cls;
    };


  private:

    virtual void detect(const cv::Mat& /* inFrame*/,  cv::Mat& /*outMask*/);

    virtual bool processRangeImplementation(frame_number_t first, 
                                            frame_number_t last, 
					    UiCallback* uiCallback);

    void propagateRange(int firstframe,int lastframe, bool trainColourModel);

    BinaryClassifier *cls;
    float corethreshold;
    float outerthreshold;

   
  };

  struct propagationRecord {
    int row;
    int col;
    int frame;
    int orgTime; // iteration that pushed this record into stack 
  };



  // helper functions

  void floatimagesc(const std::string &str, cv::Mat f);

  void extractMovementMask(localBlackBoardType &blackboard, 
			   std::string &targetid,
			   int firstframe, int lastframe);
  
  bool propagationTestBall(size_t row, size_t col, size_t frame, float pthreshold, size_t testballradius, localBlackBoardType &bb, BinaryClassifier &cls, FeatureExtractor &fe);
  
  void propagateSkin(int firstframe, int lastframe, 
		     int videofirst, int videolast,
		     localBlackBoardType &bb, const std::string &progressid,
		     float corethreshold, float outerthreshold,
		     BinaryClassifier &cls, FeatureExtractor &fe);

  void doSkinPropagation(int firstframe, int lastframe,
			 int videofirst, int videolast,
			 localBlackBoardType &bb, const std::string &progressid,
			 float threshold, size_t ballradius,
			 BinaryClassifier &cls, 
			 FeatureExtractor &fe, const std::string *restrictionid=NULL);


  void downsampleFrame(cv::Mat &src, cv::Mat &dst, float factor);

  void detectShadows(int firstframe, int lastframe,
		     localBlackBoardType &bb, const std::string &objectmaskid,
		     const std::string &shadowmaskid);

  void temporalSmoothPmap(localBlackBoardType &bb, const std::string &pmapid, 
			  const std::string &skinmaskid,int firstframe,
			  int lastframe);

  void sampleFrames(localBlackBoardType &bb,const std::string &skinmaskid, 
		    const std::string &pmapid,bool weightsamples,
		    const std::vector<size_t> &framesToSample,
		    std::vector<std::vector<float> > &negSamples,
		    std::vector<std::vector<float> > &posSamples,
		    std::vector<float> &negWeights,
		    std::vector<float> &posWeights,
		    FeatureExtractor &fe,
		    bool underfacetriangle,bool allmask, bool facearea,
		    bool negblockface, bool negblockmask, bool negblockfacelike,
		    bool negimportancesampling);

  void watershedSegmentation(cv::Mat &srcimg, cv::Mat &dstmask,size_t gridspacing);

  void falseColour32BitImg(cv::Mat &src, cv::Mat &dst);

  void extractColourHistograms(cv::Mat &srcimg,cv::Mat &lblimg,std::vector<std::vector<int> > &histograms);

  void extractColourHistogram(cv::Mat &srcimg,cv::Rect &roi, std::vector<int> &histogram);

  int quantiseBGR(cv::Vec3b &bgr);

  void rgb_to_hsv(float &r, float &g, float &b);

  float chisqrdist(std::vector<int> &h1, std::vector<int> &h2);

  void displayHist(std::vector<int> &h);

  void dumpHist(std::vector<int> &h);

  std::vector<int> sortedordering(std::vector<float> v);

  void estimateBackgroundWatershed(int firstframe, int lastframe, localBlackBoardType &bb);

  void findNonBackgroundBlocks(int firstframe, int lastframe, 
			       localBlackBoardType &bb, const std::string &fgid);


}

#endif
