#include "PythonBlackBoard.hpp"

namespace slmotion {
  namespace python {
    const int PythonBlackBoard::NONE = static_cast<int>(BlackBoardEntry::NONE);
    const int PythonBlackBoard::COMPRESS_WITHOUT_REFERENCES = 
      static_cast<int>(BlackBoardEntry::COMPRESS_WITHOUT_REFERENCES);
    
    BlackBoardEntry::BlackBoardEntryAttribute PythonBlackBoard::intToAttribute(int integer) {
      switch (integer) {
      case NONE:
        return BlackBoardEntry::NONE;
        break;

      case COMPRESS_WITHOUT_REFERENCES:
        return BlackBoardEntry::COMPRESS_WITHOUT_REFERENCES;
        break;

      default:
        throw std::out_of_range("The given integer does not correspond to an enum!");
        return BlackBoardEntry::NONE; // dummy return
      }
    }
  }
}
