#ifndef SLMOTION_PYTHON_BLACKBOARD
#define SLMOTION_PYTHON_BLACKBOARD

#include "PythonEnvironment.hpp"
#include "util.hpp"

namespace slmotion {
  namespace python {
    /**
     * This class is a Python-wrapper for the BlackBoard
     */
    class PythonBlackBoard {
    public:
      // "python enums"
      static const int NONE;
      static const int COMPRESS_WITHOUT_REFERENCES;
      static BlackBoardEntry::BlackBoardEntryAttribute intToAttribute(int integer);

      PythonBlackBoard() = default;

      inline bool has(const BlackBoard::property_key_t& property,
               BlackBoard::frame_number_t framenr) {
        return getEnv()->getBlackBoard()->has(framenr, property);
      }

      inline bool has(const BlackBoard::property_key_t& property) {
        return getEnv()->getBlackBoard()->has(property);
      }

      inline boost::python::object get(const BlackBoard::property_key_t& property,
                                BlackBoard::frame_number_t framenr) {
        BlackBoardPointer<boost::any> any = getEnv()->getBlackBoard()->get(framenr, property);
        return anyToObject(*any);
      }

      inline boost::python::object get(const BlackBoard::property_key_t& property) {
        BlackBoardPointer<boost::any> any = getEnv()->getBlackBoard()->get(property);
        return anyToObject(*any);
      }

      inline void set(const boost::python::object& object, 
                      const BlackBoard::property_key_t& property,
                      int framenr = -1,
                      int attribs = COMPRESS_WITHOUT_REFERENCES) {
        if (framenr < 0)
          getEnv()->getBlackBoard()->set(property, objectToAny(object),
                                         intToAttribute(attribs));
        else
          getEnv()->getBlackBoard()->set(framenr, property, objectToAny(object),
                                         intToAttribute(attribs));
      }



      /**
       * Try to interpret the object as the given custom type
       */
      void setAs(const boost::python::object& object, 
                 const std::string& targetType,
                 const BlackBoard::property_key_t& property,
                 int framenr = -1,
                 int attribs = COMPRESS_WITHOUT_REFERENCES) {
        if (framenr < 0)
          getEnv()->getBlackBoard()->set(property, objectToAnyAs(object, targetType),
                                         intToAttribute(attribs));
        else
          getEnv()->getBlackBoard()->set(framenr, property, objectToAnyAs(object, targetType),
                                         intToAttribute(attribs));
      }

      inline void delete_(const BlackBoard::property_key_t& property,
                          int framenr = -1) {
        if (framenr < 0)
          getEnv()->getBlackBoard()->erase(property);
        else
          getEnv()->getBlackBoard()->erase(framenr, property);
      }

      inline void deleteAll(const BlackBoard::property_key_t& property) {        
        getEnv()->getBlackBoard()->eraseAll(property);
      }

      inline void clear() {
        getEnv()->getBlackBoard()->clear();
      }
    };
  }
}
#endif
