#ifndef SLMOTION_PYTHON_FRAMESOURCE
#define SLMOTION_PYTHON_FRAMESOURCE

#include "PythonEnvironment.hpp"

namespace slmotion {
  namespace python {
        /**
     * This class is a Python-wrapper for the FrameSource
     */
    class PythonFrameSource {
    public:
      PythonFrameSource() :
        frameSource(nullptr) {}

      explicit PythonFrameSource(FrameSource* fs) :
        frameSource(fs) {}

      // wrapper for the bracket operator
      boost::python::object getFrame(int index) const {
        if (frameSource != nullptr) {
          boost::python::object o = matrixToNumpyArray((*frameSource)[index]);
          return o;
        }
        else {
          boost::python::object o = matrixToNumpyArray((*getEnv()->getMainFrameSource())[index]);
          return o;
        }
      }

      int len() const {
        return frameSource ? frameSource->size() : getEnv()->getMainFrameSource()->size();
      }

      int getNumberOfTracks() const {
        return frameSource ? frameSource->getNumberOfTracks() : 
          getEnv()->getMainFrameSource()->getNumberOfTracks();
      }

      // this is the obvious wrapper for FrameSource::getTrack()
      // however, because the implementation depends on the class_ instance,
      // it is not defined here
      boost::python::object getTrack(int trackNumber) {
        if (frameSource)
          return boost::python::object(PythonFrameSource(&frameSource->getTrack(trackNumber)));
        else
          return boost::python::object(PythonFrameSource(&getEnv()->getMainFrameSource()->getTrack(trackNumber)));
      }


    private:
      FrameSource* frameSource;
    };
  }
}

#endif
