#ifndef SLMOTION_RAW_FACE_DETECTOR
#define SLMOTION_RAW_FACE_DETECTOR

#include "ViolaJonesFaceDetector.hpp"

namespace slmotion {
  const std::string FACEDETECTOR_RAW_FACE_VECTOR_BLACKBOARD_ENTRY = "rawfacevector";
  // raw face detection results, vector<Rect>

  /**
   * Performs raw face detections and stores multiple face locations per frame in a vector on 
   * the black board
   */
  class RawFaceDetector : ViolaJonesFaceDetector {
  public:
    virtual ~RawFaceDetector() { }
    


    explicit RawFaceDetector(BlackBoard* blackBoard, FrameSource* frameSource,
                             const std::string& cascadeFilenameArgument) :
      ViolaJonesFaceDetector(blackBoard, frameSource, cascadeFilenameArgument) {
    }



    virtual void process(frame_number_t framenumber);



    virtual property_set_t getProvided() const {
      return property_set_t { FACEDETECTOR_RAW_FACE_VECTOR_BLACKBOARD_ENTRY };
    }
      
    
    
    virtual std::string getShortDescription() const {
      return "Detects faces in the frame and returns a raw vector with multiple face "
        "candidates";
    }



    virtual std::string getLongDescription() const {
      return "Detects faces in the frame and returns a raw vector with multiple face "
        "candidates";
    }



    virtual property_set_t getRequirements() const {
      return property_set_t();
    }



    virtual std::string getShortName() const {
      return "RawFaceDetector";
    }



    virtual std::string getComponentName() const {
      return "Raw Face Detector";
    }



    virtual void reset() {
    }



    virtual boost::program_options::options_description getConfigurationFileOptionsDescription() const;
    virtual boost::program_options::options_description getCommandLineOptionsDescription() const{
      return boost::program_options::options_description();
    }



    RawFaceDetector(bool) : ViolaJonesFaceDetector(true) {}

  private:
    virtual Component* createComponentImpl(const boost::program_options::variables_map& configuration, BlackBoard* blackBoard, FrameSource* frameSource) const;

  };
}

#endif
