#include "SLMotionConfiguration.hpp"

#include <boost/program_options.hpp>

namespace slmotion {
  namespace configuration {
    SLMotionConfiguration::~SLMotionConfiguration() {
    }

    SLMotionConfiguration::SLMotionConfiguration() :
      configurationVariables(new boost::program_options::variables_map),
      annotationFormat("Frame: %f"), 
      videoOutput(true), aspect(-1), scale(-1,-1),
      // annotationTemplateFilename("default.ann"),
      // doBlobDetection(true),
      //      faceDetectorCascadeFilename(HAAR_DEFAULT_FACE_CASCADE_FILE),
      showTrackedPoints(false), showMotionVectors(false), 
      showAccelerationVectors(false), 
      showBodyParts(false),
      showBlobCentroids(false),
      showEstimatedAnchors(false),
      showCorners(false),
      showSkinMask(false),
      disableAnnotationBar(false),
      showBlobs(false),
      showGradientMap(false),
      showGradientMap2d(false),
      showCannyMap(false),
      showFace(false),
      showAsms(false),
      // visualiserCombinationStyle(Visualiser::NONE),
      videoFps(25.0),
      videoFourCC("MJPG"),
      // colourSpace(new RGBColourSpace()),
      // KLTRemoveNonMaskedFeatures(true),
      // KLTMaxFrameError(1000),
      // KLTGFQuality(0.01),
      // KLTGFMinDistance(3),
      // KLTMaxPoints(1000),
      // KLTMaxMove(30),
      // classifyHeadSizeFactor(3.4),
      // classifyHeadMaxDistance(50),
      // goodFrameMinHandHDist(0),
      // goodFrameMinHandHeadVDist(0),
      // goodFrameMaxHeadDisplacement(1000),
      pauseMode(false),
      skipFrames(0),
      framesMax(SIZE_MAX),
      storeImages(false),
      maxThreads(0),
      videoBackend(OPENCV),
      frameCacheSize(SIZE_MAX) {
    }

    SLMotionConfiguration::SLMotionConfiguration(const SLMotionConfiguration& that) :
      configurationVariables(new boost::program_options::variables_map(*that.configurationVariables)),
      inputFilename(that.inputFilename),
      aliases(that.aliases),
      script(that.script),
      analyserComponents(that.analyserComponents),
#ifdef SLMOTION_ENABLE_PICSOM
      picsomDataBaseName(that.picsomDataBaseName),
      picsomArgs(that.picsomArgs),
#endif // SLMOTION_ENABLE_PICSOM
      elanOutputFilename(that.elanOutputFilename),
      annotationFormat(that.annotationFormat),
      annotationFilename(that.annotationFilename),
      outputFilename(that.outputFilename),
      videoOutput(that.videoOutput),
      aspect(that.aspect),
      scale(that.scale),
      annotationTemplateFilename(that.annotationTemplateFilename),
      showTrackedPoints(that.showTrackedPoints),
      showMotionVectors(that.showMotionVectors),
      showAccelerationVectors(that.showAccelerationVectors),
      featureOutputFilename(that.featureOutputFilename),
      showBodyParts(that.showBodyParts),
      showBlobCentroids(that.showBlobCentroids),
      showEstimatedAnchors(that.showEstimatedAnchors),
      showCorners(that.showCorners),
      showSkinMask(that.showSkinMask),
      disableAnnotationBar(that.disableAnnotationBar),
      complexVisualisation(that.complexVisualisation),
      showBlobs(that.showBlobs),
      showGradientMap(that.showGradientMap),
      showGradientMap2d(that.showGradientMap2d),
      showCannyMap(that.showCannyMap),
      showFace(that.showFace),
      showAsms(that.showAsms),
      videoFps(that.videoFps),
      videoFourCC(that.videoFourCC),
      pauseMode(that.pauseMode),
      skipFrames(that.skipFrames),
      framesMax(that.framesMax),
      storeImages(that.storeImages),
      maxThreads(that.maxThreads),
      videoBackend(that.videoBackend),
      frameCacheSize(that.frameCacheSize)
    { }

    SLMotionConfiguration& SLMotionConfiguration::operator=(const SLMotionConfiguration& that) {
      if (this != &that) {
        SLMotionConfiguration temp(that);

        std::swap(configurationVariables, temp.configurationVariables);
        std::swap(inputFilename, temp.inputFilename);
        std::swap(aliases, temp.aliases);
        std::swap(script, temp.script);
        std::swap(analyserComponents, temp.analyserComponents);
#ifdef SLMOTION_ENABLE_PICSOM
        std::swap(picsomDataBaseName, temp.picsomDataBaseName);
        std::swap(picsomArgs, temp.picsomArgs);
#endif // SLMOTION_ENABLE_PICSOM
        std::swap(elanOutputFilename, temp.elanOutputFilename);
        std::swap(annotationFormat, temp.annotationFormat);
        std::swap(annotationFilename, temp.annotationFilename);
        std::swap(outputFilename, temp.outputFilename); ///< video or image sequence output
        std::swap(videoOutput, temp.videoOutput);
        std::swap(aspect, temp.aspect);
        std::swap(scale, temp.scale);
        std::swap(annotationTemplateFilename, temp.annotationTemplateFilename);
        std::swap(showTrackedPoints, temp.showTrackedPoints);
        std::swap(showMotionVectors, temp.showMotionVectors);
        std::swap(showAccelerationVectors, temp.showAccelerationVectors);
        std::swap(featureOutputFilename, temp.featureOutputFilename);
        std::swap(showBodyParts, temp.showBodyParts);
        std::swap(showBlobCentroids, temp.showBlobCentroids);
        std::swap(showEstimatedAnchors, temp.showEstimatedAnchors);
        std::swap(showCorners, temp.showCorners);
        std::swap(showSkinMask, temp.showSkinMask);
        std::swap(disableAnnotationBar, temp.disableAnnotationBar);
        std::swap(complexVisualisation, temp.complexVisualisation);
        std::swap(showBlobs, temp.showBlobs);
        std::swap(showGradientMap, temp.showGradientMap);
        std::swap(showGradientMap2d, temp.showGradientMap2d);
        std::swap(showCannyMap, temp.showCannyMap);
        std::swap(showFace, temp.showFace);
        std::swap(showAsms, temp.showAsms);
        std::swap(videoFps, temp.videoFps);
        std::swap(videoFourCC, temp.videoFourCC);
        std::swap(pauseMode, temp.pauseMode);
        std::swap(skipFrames, temp.skipFrames);
        std::swap(framesMax, temp.framesMax);
        std::swap(storeImages, temp.storeImages);
        std::swap(maxThreads, temp.maxThreads);
        std::swap(videoBackend, temp.videoBackend);
        std::swap(frameCacheSize, temp.frameCacheSize);
      }
      return *this;
    }
  }
}

