#ifndef SLMOTION_CONFIGURATION_STRUCT
#define SLMOTION_CONFIGURATION_STRUCT

#include <opencv2/opencv.hpp>
#include <vector>
#include <memory>

// forward declaration (#include cannot be done because of bugs in Qt's moc)
namespace boost {
  namespace program_options {
    class variables_map;
  }
}

namespace slmotion {
  namespace configuration {
    /**
     * This struct explains the configuration of the program and the process
     * This is an internal representation that can be created from various 
     * sources, e.g. configuration file or command line
     */
    class SLMotionConfiguration {
    public:
      ~SLMotionConfiguration();

      SLMotionConfiguration(const SLMotionConfiguration&);
      SLMotionConfiguration& operator=(const SLMotionConfiguration&);

      std::unique_ptr<boost::program_options::variables_map> configurationVariables;
      std::string inputFilename;
      std::map<std::string, std::vector<std::string> > aliases; ///< Component aliases
      std::string script; ///< Python script filename
      std::vector<std::string> analyserComponents; //< List of analyser components
  
#ifdef SLMOTION_ENABLE_PICSOM
      std::string picsomDataBaseName;
      std::string picsomArgs;
#endif // SLMOTION_ENABLE_PICSOM

      std::string elanOutputFilename;
      std::string annotationFormat;
      std::string annotationFilename;
      std::string outputFilename; ///< video or image sequence output
      bool videoOutput;
      double aspect;
      cv::Size scale;
      std::string annotationTemplateFilename;
      bool showTrackedPoints;
      bool showMotionVectors;
      bool showAccelerationVectors;
      std::string featureOutputFilename;
      bool showBodyParts;
      bool showBlobCentroids;
      bool showEstimatedAnchors;
      bool showCorners;
      bool showSkinMask;
      bool disableAnnotationBar;
      std::string complexVisualisation;
      bool showBlobs;
      bool showGradientMap;
      bool showGradientMap2d;
      bool showCannyMap;
      bool showFace;
      bool showAsms;
      // Visualiser::CombinationStyle visualiserCombinationStyle;
      double videoFps;
      std::string videoFourCC;
      // std::pair<double,double> faceScale;
      // std::pair<int,int> faceTranslate;
      // std::shared_ptr<ColourSpace> colourSpace;
      // std::vector < std::shared_ptr<PostProcessFilter> > skinDetectorPostProcessFilters;
      
      // bool KLTRemoveNonMaskedFeatures;
      // double KLTMaxFrameError;
      // double KLTGFQuality;
      // double KLTGFMinDistance;
      // int KLTMaxPoints;
      // int KLTMaxMove;
      
      // double classifyHeadSizeFactor;
      // int classifyHeadMaxDistance;
      // int goodFrameMinHandHDist;
      // int goodFrameMinHandHeadVDist;
      // int goodFrameMaxHeadDisplacement;     

      bool pauseMode;
      size_t skipFrames;
      size_t framesMax;
      bool storeImages;
      // std::string elanFilename;

      size_t maxThreads; ///< Global maximum number of threads

      enum VideoBackEnd {
        OPENCV
      } videoBackend;

      size_t frameCacheSize;
      
      SLMotionConfiguration();
    };
  }
}
#endif
