#ifndef SLMOTION_SINGLETON_WINDOW
#define SLMOTION_SINGLETON_WINDOW

#ifdef SLMOTION_WITH_GTK
#include <gtk/gtk.h>

namespace slmotion {
  namespace gui {
    /**
     * This class represents a window for which only one instance
     * should exist at a time. On creation, a pointer to the pointer
     * is passed and stored, which is used by the destruction function
     * to release any acquired resources and nullify the pointer
    */
    class SingletonWindow {
    public:
      explicit SingletonWindow(SingletonWindow** pointer);

      virtual ~SingletonWindow() = 0;

      inline GtkWindow* getWindow() {
        return window;
      }

    private:
      /**
       * Destroys the instance and nullifies the pointer. 
       *
       * @param pointer Pointer to the pointer of the instance
       */
      static void destroy(GtkWidget*, gpointer pointer);



      GtkWindow* window;
    };
  } 
}

#endif // SLMOTION_WITH_GTK
#endif
