#include "XmlNode.hpp"
#include "configuration.hpp"
#include "util.hpp"
#include "xmlutil.hpp"
#include "SomPakHeaderDocument.hpp"
#include <cstring>
#include <boost/lexical_cast.hpp>
#include <pwd.h>

using std::string;
using boost::lexical_cast;

namespace slmotion {
  std::string getSomPakFeatureSchemaFile() {
    return getInstallPrefix() + "/share/slmotion/feature.xsd";
  }

  void SomPakHeaderDocument::initialise(const std::string& name, 
                                        const std::string& longName, 
                                        const std::string& shortText,
                                        const std::string& target) {
    if (debug > 1)
      std::cerr << "slmotion: SomPakHeaderDocument::initialise()" << std::endl
                << "slmotion: SomPakHeaderDocument: construct root node" 
                << std::endl;
    xml::XmlNode root("feature");

    if (debug > 1)
      std::cerr << "slmotion: SomPakHeaderDocument: set root node" 
                << std::endl;
    setRootElement(root);

    if (debug > 1)
      std::cerr << "slmotion: SomPakHeaderDocument: add text children to the "
                << "root node" << std::endl;

    root.newTextChild("name", name);
    root.newTextChild("longname", longName);
    root.newTextChild("shorttext", shortText);
    root.newTextChild("target", target);
    root.newTextChild("vectorlength", "0");
    root.newTextChild("options", "");
    root.newTextChild("hasrawin", "yes");
    root.newTextChild("hasrawout", "yes");

    if (debug > 1)
      std::cerr << "slmotion: SomPakHeaderDocument: add components node" 
                << std::endl;
    xml::XmlNode node("components");

    if (debug > 1)
      std::cerr << "slmotion: SomPakHeaderDocument: add components node as " 
                << "child to the root node" << std::endl;
    root.addChild(node);

    if (debug > 1)
      std::cerr << "slmotion: SomPakHeaderDocument: add version text child to "
                << "the components node" << std::endl;
    root.newTextChild("version", "$Id: ");

    if (debug > 1)
      std::cerr << "slmotion: SomPakHeaderDocument: construct time code" 
                << std::endl;
    // time code
    time_t rawtime;
    struct tm* timeinfo;
    time(&rawtime);
    timeinfo = localtime(&rawtime);
    char* temp = asctime(timeinfo);
    temp[strlen(temp)-1] = '\0'; // remove trailing newline
    if (debug > 1)
      std::cerr << "slmotion: SomPakHeaderDocument: constructed time code:" 
                << temp << std::endl
                << "slmotion: SomPakHeaderDocument: Add time code as text "
                << "child:" << std::endl;
    root.newTextChild("date", temp);

    // if (debug > 1)
    //   std::cerr << "slmotion: SomPakHeaderDocument: getLogin(): ";
    // char* login_p = getlogin();
    // std::string login = login_p == NULL ? "NULL" : login_p;

    if (debug > 1)
      std::cerr << "slmotion: SomPakHeaderDocument: getuid(): ";
    uid_t uid = getuid();
    if (debug > 1)
      std::cerr << "slmotion: SomPakHeaderDocument: got uid: " << uid 
                << std::endl;

    if (debug > 1)
      std::cerr << "slmotion: SomPakHeaderDocument: getpwuid()" << std::endl;
    struct passwd* pw = getpwuid(uid);
    std::string login = pw->pw_name == NULL ? "NULL" : pw->pw_name;
    if (debug > 1)
      std::cerr << "slmotion: SomPakHeaderDocument: getpwuid(): got name: " 
                << login << std::endl;    

    if (debug > 1)
      std::cerr << "slmotion: SomPakHeaderDocument: add login as text child"
                << std::endl;
    root.newTextChild("user", login);
    
    if (debug > 1)
      std::cerr << "slmotion: SomPakHeaderDocument: get hostname" << std::endl;
    char hostname[256];
    gethostname(hostname, 256);
    if (debug > 1)
      std::cerr << "slmotion: SomPakHeaderDocument: got hostname: " << hostname
                << std::endl
                << "slmotion: SomPakHeaderDocument: add hostname as text child"
                << std::endl;
    root.newTextChild("host", hostname);

    if (debug > 1)
      std::cerr << "slmotion: SomPakHeaderDocument: get cwd" << std::endl;
    char* cwd = getcwd(NULL, 0); // get_current_dir_name();
    if (debug > 1)
      std::cerr << "slmotion: SomPakHeaderDocument: got cwd:" << cwd 
                << std::endl
                << "slmotion: SomPakHeaderDocument: add cwd as text child" 
                << std::endl;
    root.newTextChild("cwd", cwd);
    free(cwd);
    if (debug > 1)
      std::cerr << "slmotion: SomPakHeaderDocument: add argV: \"" << getArgV()
                << "\" as text child" << std::endl;
    root.newTextChild("cmdline", getArgV());
    if (debug > 1)
      std::cerr << "slmotion: SomPakHeaderDocument: done!" << std::endl;
  }



  void SomPakHeaderDocument::addComponents(const std::vector<SOM_PAK_Component>& components) {
    xml::XmlNode node = getRoot().getChild("vectorlength");
    node.setContent(lexical_cast<string>(components.size()));
    xml::XmlNode componentsNode = getRoot().getChild("components");

    for(size_t i = 0; i < components.size(); ++i) {
      const SOM_PAK_Component& it = components[i];
      xml::XmlNode component = xml::XmlNode("component");
      component.newProperty("index", lexical_cast<string>(it.getIndex()));
      component.newProperty("name", it.getName());
      component.newProperty("min-value", 
                            lexical_cast<string>(it.getMinValue<double>()));
      component.newProperty("max-value", 
                            lexical_cast<string>(it.getMaxValue<double>()));
      string valueType;
      switch(it.getValueType()) {
      case SOM_PAK_Component::ValueType::INTEGER:
        valueType = "integer";
        break;
      case SOM_PAK_Component::ValueType::REAL:
        valueType = "real";
        break;
      case SOM_PAK_Component::ValueType::BOOLEAN:
        valueType = "boolean";
        break;
      }
      component.newProperty("value-type", valueType);
      componentsNode.addChild(component);
    }
  }
}
