#ifndef SLMOTION_SOMPAK_HEADER_DOCUMENT
#define SLMOTION_SOMPAK_HEADER_DOCUMENT

#include "XmlValidableDocument.hpp"
#include "SOM_PAK_Component.hpp"
#include <vector>
#include <iostream>

namespace slmotion {
  extern int debug;

  /**
   * Schema file for SOM_PAK feature component description
   */
  std::string getSomPakFeatureSchemaFile();

  /**
   * This class represents a SOM_PAK header
   */
  class SomPakHeaderDocument : public xml::XmlValidableDocument {
  public:
    SomPakHeaderDocument(const std::string& name, 
                         const std::string& longName, 
                         const std::string& shortText,
                         const std::string& target) : 
      XmlValidableDocument(xml::Validator(getSomPakFeatureSchemaFile())) {
      if (debug > 1)
        std::cerr << "slmotion: SomPakHeaderSocument::SomPakHeaderDocument()"
                  << std::endl;
      initialise(name, longName, shortText, target);
    }

    void addComponents(const std::vector<SOM_PAK_Component>& component);

  private:
    /**
     * Initialises an empty document
     */
    void initialise(const std::string& name, 
                    const std::string& longName, 
                    const std::string& shortText,
                    const std::string& target); 

    // no copies because of pointer members
    SomPakHeaderDocument(const SomPakHeaderDocument&) = delete;
    SomPakHeaderDocument& operator=(const SomPakHeaderDocument&) = delete;
  };
}
#endif

