#include "StaticElmSkinDetector.hpp"
#include "SkinDetector.hpp"

namespace slmotion {
  static StaticElmSkinDetector DUMMY(true);

  void StaticElmSkinDetector::detect(const cv::Mat& frame, cv::Mat& outMask) { // frame_number_t fn) {
    // const cv::Mat& frame = getFrameSource()[fn];
    // cv::Mat temp(frame.size(), CV_8UC1, cv::Scalar::all(0));
    outMask = cv::Mat(frame.size(), CV_8UC1, cv::Scalar::all(0));
    for (int i = 0; i < frame.rows; ++i) 
      for (int j = 0; j < frame.cols; ++j) 
        if (elm.predict(frame.at<cv::Vec3b>(i,j)) > classificationThreshold) //> 0)
          outMask.at<uchar>(i,j) = 255;
        else
          outMask.at<uchar>(i,j) = 0;

    // getBlackBoard().set(fn, SKINDETECTOR_BLACKBOARD_MASK_ENTRY, temp);
  }



  void StaticElmSkinDetector::process(size_t framenr) {
    const cv::Mat& inFrame = getFrameSource()[framenr];
    cv::Mat outMask = cv::Mat(inFrame.size(), CV_8UC1, cv::Scalar::all(0));

    // detection
    detect(inFrame, outMask);

    // post processing
    cv::morphologyEx(outMask, outMask, cv::MORPH_OPEN, 
                     cv::getStructuringElement(cv::MORPH_ELLIPSE, cv::Size(5,5)), 
                     cv::Point(-1,-1), 1);
    cv::morphologyEx(outMask, outMask, cv::MORPH_CLOSE, 
                     cv::getStructuringElement(cv::MORPH_ELLIPSE, cv::Size(5,5)), 
                     cv::Point(-1,-1), 1);
    PostProcessHoleFillerFilter holeFiller;
    holeFiller.apply(cv::Mat(), outMask);
    

    getBlackBoard().set(framenr, SKINDETECTOR_BLACKBOARD_MASK_ENTRY, outMask);

  }



  Component* StaticElmSkinDetector::createComponentImpl(const boost::program_options::variables_map& configuration, BlackBoard* blackBoard, FrameSource* frameSource) const {
    if (!configuration.count("StaticElmSkinDetector.model"))
        throw ConfigurationFileException("model is a mandatory option for StaticElmSkinDetector!");

    std::string fn = configuration["StaticElmSkinDetector.model"].as<std::string>();

    CvElmClassifier elm(fn);

    double threshold = 0.0;
    if (configuration.count("StaticElmSkinDetector.threshold")) {
      threshold = configuration["StaticElmSkinDetector.threshold"].as<double>();
      if (threshold < -1.0 || threshold > 1.0)
        throw ConfigurationFileException("Classification threshold must be in [-1,1]!");
    }

    auto conf2(configuration);
    if (!conf2.count("SkinDetector.postprocess")) {
      boost::program_options::variable_value v(boost::any(std::string()), false);
      conf2.insert(std::make_pair(std::string("SkinDetector.postprocess"), v));
      v = boost::program_options::variable_value(boost::any(std::string("bgr")), false);
      conf2.insert(std::make_pair(std::string("SkinDetector.colourspace"), v));
    }

    return new StaticElmSkinDetector(blackBoard, frameSource, conf2, elm, threshold);
  }

  boost::program_options::options_description 
  StaticElmSkinDetector::getConfigurationFileOptionsDescription() const {
    boost::program_options::options_description opts;
    opts.add_options()
      ("StaticElmSkinDetector.model", 
       boost::program_options::value<std::string>()->default_value(""),
       "Filename of the model file produced with trainelm")
      ("StaticElmSkinDetector.threshold", 
       boost::program_options::value<double>()->default_value(0.0),
       "Classification threshold in [-1,1]");
    
    return opts;
  }
}
