#ifndef SLMOTION_STATIC_ELM_SKIN_DETECTOR
#define SLMOTION_STATIC_ELM_SKIN_DETECTOR

#include "SkinDetector.hpp"
#include "ELMClassifier.hpp"

namespace slmotion {
  /**
   * Detects skin using a static model
   */
  class StaticElmSkinDetector : public SkinDetector {
  public:
    StaticElmSkinDetector(bool) : SkinDetector(true) { }



    StaticElmSkinDetector(BlackBoard* blackBoard, FrameSource* frameSource,
                          const boost::program_options::variables_map& configuration,
                          const CvElmClassifier& elm, double threshold = 0.0) :
      SkinDetector(configuration, blackBoard, frameSource), elm(elm), classificationThreshold(threshold) { }



    StaticElmSkinDetector(BlackBoard* blackBoard, FrameSource* frameSource,
                          const boost::program_options::variables_map& configuration,
                          CvElmClassifier&& elm, double threshold = 0.0) :
      SkinDetector(configuration, blackBoard, frameSource), elm(std::move(elm)), 
      classificationThreshold(threshold) { }



    void process(size_t framenr);



    virtual void detect(const cv::Mat& frame, cv::Mat& outMask);



    virtual std::string getShortDescription() const {
      return "ELM-based skin detector";
    }



    virtual std::string getLongDescription() const {
      return "Detects skin using a static ELM-based model";
    }



    virtual property_set_t getRequirements() const {
      return property_set_t();
    }

    // virtual property_set_t getProvided() const {
    //   return property_set_t();
    // }

    virtual std::string getShortName() const {
      return "StaticElmSkinDetector";
    }



    virtual std::string getComponentName() const {
      return "Static ELM Skin Detector";
    }

    // virtual void reset() {
    // }

    virtual boost::program_options::options_description 
    getConfigurationFileOptionsDescription() const;



    virtual boost::program_options::options_description getCommandLineOptionsDescription() const {
      return boost::program_options::options_description();
    }

  private:
    virtual Component* createComponentImpl(const boost::program_options::variables_map& configuration, BlackBoard* blackBoard, FrameSource* frameSource) const;

    CvElmClassifier elm;
    double classificationThreshold; // threshold in [-1,1]
  };
}

#endif

