#ifdef SLMOTION_ENABLE_LIBFLANDMARK
#include "SuviOcclusionFeatureCreator.hpp"

namespace slmotion {
  static SuviOcclusionFeatureCreator DUMMY(true);

  bool SuviOcclusionFeatureCreator::processRangeImplementation(frame_number_t first, 
                                                               frame_number_t last,
                                                               UiCallback*) {
    std::vector<SOM_PAK_Component> components {
      {0, "framenr", 0, 999999, SOM_PAK_Component::ValueType::INTEGER, 
          "1"}, // 0
      {1, "timecode", 0, 999999, SOM_PAK_Component::ValueType::INTEGER, 
            "ms"}, // 1
      {2, "n_occluded_pixels", 0, 999999, 
              SOM_PAK_Component::ValueType::INTEGER, "1"}, // 2
      {3, "n_cheeks_pixels", 0, 999999, 
                SOM_PAK_Component::ValueType::INTEGER, "1"}, // 3
      {4, "n_nose_pixels", 0, 999999, 
                  SOM_PAK_Component::ValueType::INTEGER, "1"}, // 4
      {5, "n_mouth_pixels", 0, 999999, 
                    SOM_PAK_Component::ValueType::INTEGER, "1"}, // 5
      {6, "n_neck_pixels", 0, 999999, 
                      SOM_PAK_Component::ValueType::INTEGER, "1"}, // 6
      {7, "n_forehead_pixels", 0, 999999, 
                        SOM_PAK_Component::ValueType::INTEGER, "1"}, // 7
    };
    std::vector<std::vector<boost::any>> features;

    features.push_back(createFrameNumberVector(first, last));
    features.push_back(createTimeCodeVector(first, last, fps));

    features.insert(features.end(), 6, std::vector<boost::any>(last-first));
    for (size_t u = first; u < last; ++u) {
      BlackBoardPointer<cv::Mat> suviSegments = getBlackBoard().get<cv::Mat>(u, FACESUVISEGMENTS_BLACKBOARD_ENTRY);
      BlackBoardPointer<cv::Mat> occlusionsPtr;
      if (getBlackBoard().has(u, FACEOCCLUSIONDETECTOR_BLACKBOARD_MASK_ENTRY))
        getBlackBoard().get<cv::Mat>(u, FACEOCCLUSIONDETECTOR_BLACKBOARD_MASK_ENTRY);
      cv::Mat occlusions = getBlackBoard().has(u, FACEOCCLUSIONDETECTOR_BLACKBOARD_MASK_ENTRY)
        ? *occlusionsPtr : cv::Mat(suviSegments->size(), CV_8UC1, cv::Scalar::all(0));
      // cv::Mat temp(occlusions.size(), CV_8UC1);
      // for (int i = 0; i < temp.rows; ++i)
      //   for (int j = 0; j < temp.cols; ++j)
      //     temp.at<uchar>(i,j) = occlusions.at<uchar>(i,j) > 0 ? 255 : 0;
      size_t occludedPixelCount = cv::countNonZero(occlusions);
      
      cv::Mat cheekMat, noseMat, mouthMat, neckMat, foreheadMat;
      cv::inRange(*suviSegments, static_cast<uchar>(SuviSegment::CHEEKS),
                  static_cast<uchar>(SuviSegment::CHEEKS)+1, cheekMat);
      cv::inRange(*suviSegments, static_cast<uchar>(SuviSegment::NOSE),
                  static_cast<uchar>(SuviSegment::NOSE)+1, noseMat);
      cv::inRange(*suviSegments, static_cast<uchar>(SuviSegment::MOUTH),
                  static_cast<uchar>(SuviSegment::MOUTH)+1, mouthMat);
      cv::inRange(*suviSegments, static_cast<uchar>(SuviSegment::NECK),
                  static_cast<uchar>(SuviSegment::NECK)+1, neckMat);
      cv::inRange(*suviSegments, static_cast<uchar>(SuviSegment::FOREHEAD),
                  static_cast<uchar>(SuviSegment::FOREHEAD)+1, foreheadMat);

      size_t cheekOccludedPixelCount = cv::countNonZero(cv::min(cheekMat, occlusions));
      size_t noseOccludedPixelCount = cv::countNonZero(cv::min(noseMat, occlusions));
      size_t mouthOccludedPixelCount = cv::countNonZero(cv::min(mouthMat, occlusions));
      size_t neckOccludedPixelCount = cv::countNonZero(cv::min(neckMat, occlusions));
      size_t foreheadOccludedPixelCount = cv::countNonZero(cv::min(foreheadMat, occlusions));

      features[2][u-first] = (int)occludedPixelCount;
      features[3][u-first] = (int)cheekOccludedPixelCount;
      features[4][u-first] = (int)noseOccludedPixelCount;
      features[5][u-first] = (int)mouthOccludedPixelCount;
      features[6][u-first] = (int)neckOccludedPixelCount;
      features[7][u-first] = (int)foreheadOccludedPixelCount;

      // std::cout << "Frame: " << u << " Occluded pixel count: " << occludedPixelCount 
      //           << " Occluded Cheek Pixel Count: " << cheekOccludedPixelCount << std::endl;
      // // cv::imshow("", temp);
      // // cv::waitKey(0);
    }

    getBlackBoard().set(FEATURECREATOR_FEATUREVECTOR_BLACKBOARD_ENTRY,
                        FeatureVector(components, features, first, last));
    return true;
  }
}
#endif // SLMOTION_ENABLE_LIBFLANDMARK
