#ifndef SLMOTION_SUVI_OCCLUSION_FEATURE_CREATOR
#define SLMOTION_SUVI_OCCLUSION_FEATURE_CREATOR

#include "FeatureCreator.hpp"
#include "FaceOcclusionDetector.hpp"
#include "FaceSuviSegmentator.hpp"

namespace slmotion {
  /**
   * Creates Suvi occlusion features for use with Elan
   */
  class SuviOcclusionFeatureCreator : public Component {
  public:
    virtual std::string getShortName() const {
      return "SuviOcclusionFeatureCreator";
    }

    explicit SuviOcclusionFeatureCreator(BlackBoard* blackBoard, 
                            FrameSource* frameSource) : 
      Component(blackBoard, frameSource), fps(25) {}

    inline void setFps(double d) {
      fps = d;
    }

    void process(frame_number_t) {
      assert(false && "FeatureCreator cannot be called on a single frame.");
    }

    property_set_t getRequirements() const {
      return property_set_t {
        FACESUVISEGMENTS_BLACKBOARD_ENTRY,
        FACEOCCLUSIONDETECTOR_BLACKBOARD_MASK_ENTRY
      };
    }

    property_set_t getProvided() const {
      return property_set_t {
        FEATURECREATOR_FEATUREVECTOR_BLACKBOARD_ENTRY
      };
    }

    inline virtual std::string getComponentName() const {
      return "Suvi Occlusion Feature Creator";
    }

    virtual void reset() { }

    SuviOcclusionFeatureCreator(bool) : Component(true) {}

    virtual std::string getShortDescription() const {
      return "This component goes through entries on the black board, and computes some features.";
    }



    virtual std::string getLongDescription() const {
      return "This component goes through entries on the black board, and computes some features.";
    }

    virtual boost::program_options::options_description getConfigurationFileOptionsDescription() const {
      return boost::program_options::options_description();
    }

    virtual boost::program_options::options_description getCommandLineOptionsDescription() const {
      return boost::program_options::options_description();
    }


  private:
    virtual Component* createComponentImpl(const boost::program_options::variables_map&, BlackBoard* blackBoard, FrameSource* frameSource) const {
      return new SuviOcclusionFeatureCreator(blackBoard, frameSource);
    }

    bool processRangeImplementation(frame_number_t first, 
                                    frame_number_t last,
                                    UiCallback* uiCallback = nullptr);

    double fps;
  };
}

#endif
