#ifndef SLMOTION_TS_SOM_CODEBOOK
#define SLMOTION_TS_SOM_CODEBOOK

#include "TrainingRegion.hpp"
#include "DataSet.hpp"
#include <string>
#include <vector>

namespace slmotion {
  // class implementing ts-som
  class TsSomCodebook {
  public:
    
    TsSomCodebook() {
      w=h=dim=-1;
      upper=NULL;
    }
    
    void readSom(const std::string &fn);  
    void writeSom(const std::string &fn);
    void writeSom(FILE *cod);
    void dump();
    int idx2x(int i){return i%w;}
    int idx2y(int i){return i/w;}
    int findclosest(const std::vector<float> &v);
    int findclosest(const std::vector<float> &v, const Rect& r);
    int tssom_findbmu(const std::vector<float> &v);
    Rect expanddown(int idx);
    
    float nbf(int i,int j,int d=-1);
    std::vector<int> neighbours(int i,int d=-1);
    void randominit(int w, int h, const DataSet& d);
    void initfromabove();
    
    void trainsom(float a_init, int n_rounds, const DataSet& d, int, int);
    void regiontrainiteration(TrainingRegion& r, const DataSet& d,
			      float alpha_t, int d_t);
    
    int dim;
    int w;
    int h;
    TsSomCodebook* upper;
    
    bool torus;
    
    std::vector<std::vector<float> > units;
    std::vector<std::string> labels;
  };
}
#endif
