#include "VidFileSource.hpp"

#ifdef SLMOTION_ENABLE_VIDFILE_SUPPORT

namespace slmotion {
  VidFileSource::frame_number_type VidFileSource::size() const {
    return header.num_frames;
  }



  VidFileSource::VidFileSource(const std::string& filename, size_t cacheSize) :
    FrameSource(cacheSize),
    header(VidHeader(const_cast<char*>(filename.c_str()), 
                     nullptr))
    {}



  // VidFileSource* VidFileSource::create(const std::string& filename,
  //                                      size_t cacheSize) {
  //   VidFileSource* s = new VidFileSource();
  //   s->init(filename, cacheSize);
  //   return s;
  // }



  const cv::Mat& VidFileSource::operator[](frame_number_type frameNumber) {
#ifdef SLMOTION_THREADING
    std::lock_guard<std::mutex> lock(this->mutex);
#endif

    if (frameInCache(frameNumber))
      return getFrameFromCache(frameNumber);

    if (frameNumber > size())
      throw SLIOException("Frame number out of bounds.");

    header.readFrameFromVideoFile(frameNumber);

    cv::Mat rgbFrame(header.height, header.width, CV_8UC3,
                     header.pixmap);
    cv::Mat bgrFrame;
    cv::cvtColor(rgbFrame, bgrFrame, CV_RGB2BGR);
    cacheFrame(frameNumber, bgrFrame);

    if (frameInCache(frameNumber))
      return getFrameFromCache(frameNumber);
    else 
      throw SLIOException("Failed to fetch frame.");

    const static cv::Mat bogus;
    return bogus;
  }
}

#endif

