#ifndef SLMOTION_VIDFILE_SUPPORT
#ifdef SLMOTION_ENABLE_VIDFILE_SUPPORT

#include <VidHeader.h>
#include "VideoFileSource.hpp"

namespace slmotion {
  class VidFileSource : public FrameSource {
  public:
    virtual ~VidFileSource() {}

    virtual frame_number_type size() const;

    VidFileSource(const std::string& filename,
                  size_t cacheSize = SIZE_MAX);

    virtual const cv::Mat& operator[](frame_number_type frameNumber);
    
    // static VidFileSource* create(const std::string& filenames,
    //                              size_t cacheSize = SIZE_MAX);

    virtual double getFps() const {
      return 30; // vid files do not contain this information so this
                 // is just a guess because the source of the material
                 // is American (Boston University, I believe) // Matti
    }

  private:
    VidFileSource() = default;
    VidFileSource(const VidFileSource&) = delete;
    VidFileSource& operator=(const VidFileSource&) = delete;

    VidHeader header;
#ifdef SLMOTION_THREADING
    mutable std::mutex mutex; ///< If threaded access is used, this object will be used for mutual exclusion
#endif
  };
}

#endif
#endif
