#include "VideoFileSource.hpp"

  // nothing to see here
namespace slmotion {
  VideoFileSource::~VideoFileSource() {
  }



  const cv::Mat& VideoFileSource::operator[](frame_number_type frameNumber) {
#ifdef SLMOTION_THREADING
    std::lock_guard<std::mutex> lock(this->mutex);
#endif

    if (frameInCache(frameNumber))
      return getFrameFromCache(frameNumber);

    if (currentFrameNumber > frameNumber)
      reset(filename), currentFrameNumber = 0;

    while (currentFrameNumber <= frameNumber) 
      if (!frameInCache(currentFrameNumber))
        cacheFrame(currentFrameNumber++, getFrame());

    if (frameInCache(frameNumber))
      return getFrameFromCache(frameNumber);
    else 
      throw SLIOException("Failed to fetch frame.");

    const static cv::Mat bogus;
    return bogus;
  }
}
