#ifndef SLMOTION_XML_NAMESPACE
#define SLMOTION_XML_NAMESPACE

#include "xmlutil.hpp"

namespace slmotion {
  namespace xml {
    /**
     * This class represents an XML namespace
     */
    class XmlNamespace {
    public:
      friend class XmlNode;

      /**
       * Sets the property
       */
      void newProperty(const std::string& key, const std::string& value) {
        xmlNewNsProp(holdingNode, internalNamespace,
                     toXmlChar(key), toXmlChar(value));
      }

    private:
      XmlNamespace(xmlNodePtr node, const std::string& href,
                   const std::string& prefix) :
        internalNamespace(xmlNewNs(node, toXmlChar(href), 
                                   toXmlChar(prefix))),
          holdingNode(node)
          { }

      xmlNsPtr internalNamespace;
      xmlNodePtr holdingNode;
    };
  }
}

#endif

