#include "exceptions.hpp"
#include "xmlutil.hpp"
#include "XmlNode.hpp"

namespace slmotion {
  namespace xml {
    bool XmlNode::hasChild(const std::string& name) const {
      for (auto it = begin(); it != end(); ++it) 
        if (it->getName() == name)
          return true;
      return false;
    }
    


    XmlNode XmlNode::getChild(const std::string& name) const {
      assert(*internalNode != NULL);

      for (auto it = begin(); it != end(); ++it) 
        if (it->getName() == name)
          return *it;
      
      throw slmotion::XMLException("The node \"" + getName() +
                                   "\" has no such child: " +
                                   name);
      return XmlNode(); // dummy
    }


    XmlSiblingIterator XmlNode::begin() const {
        return XmlSiblingIterator(xmlFirstElementChild(*internalNode));
    }


    XmlSiblingIterator XmlNode::end() const {
      return XmlSiblingIterator(NULL);
    }



    XmlSiblingIterator XmlNode::getSiblingIterator() const {
      return XmlSiblingIterator(*internalNode);
    }



    std::string XmlNode::getContent() const {
      xmlChar* content = xmlNodeGetContent(*internalNode);
      std::string strContent = toString(content);
      xmlFree(content);
      return strContent;
    }



    XmlNode XmlNode::getFirstChild() const {
      xmlNodePtr child = xmlFirstElementChild(*internalNode);

      if (child)
        return XmlNode(child);
      
      throw XmlException("The node has no children, yet the first child "
                         "was requested!");
      
      return XmlNode(); // dummy
    }



    XmlNode XmlNode::getLastChild(const std::string& name) const {
        xmlNodePtr child = getLastChildElementByName(*internalNode, name);
        if (child)
          return XmlNode(child);

        throw XmlException("The node \"" + getName() + "\" has no such child: "+ name);

        return XmlNode(); // dummy
    }
  }
}
