#ifndef SLMOTION_XML_SIBLING_ITERATOR
#define SLMOTION_XML_SIBLING_ITERATOR

#include "XmlNode.hpp"

namespace slmotion {
  namespace xml {
    /**
     * Iterates over XML sibling nodes
     */
    class XmlSiblingIterator {
    public:
      friend class XmlNode;

      XmlSiblingIterator& operator++();

      XmlSiblingIterator operator++(int) {
        XmlSiblingIterator temp = *this;
        ++*this;
        return temp;
      }

      XmlNode& operator*() {
        return internalNode;
      }

      XmlNode* operator->() {
        return &internalNode;
      }

      bool operator==(const XmlSiblingIterator& other) const {
        return *(this->internalNode.internalNode) == *(other.internalNode.internalNode);
      }

      bool operator!=(const XmlSiblingIterator& other) const {
        return !(*this == other);
      }

      XmlSiblingIterator(const XmlSiblingIterator&) = default;
      XmlSiblingIterator& operator=(const XmlSiblingIterator&) = default;

    private:
      XmlSiblingIterator(xmlNodePtr node) :
        internalNode(node) { }

      XmlNode internalNode;
    };
  }
}

#endif
