#!/bin/sh

# parse arguments
while true; do
    if [ $1 ]; then
        if [ $1 = --help ]; then
            echo $0: a script to compile slmotion on ICS workstations
            echo Optional arguments:
            echo   --help:  Print this text.
            echo   --clean: Do a clean build \(ignore cache\)
            exit
        elif [ $1 = --clean ]; then
            echo Cleaning... \\c
            rm -fv build/CMakeCache.txt
            rm -rfv build/CMakeFiles
            echo Done.
        else
            echo $0: $1: invalid command-line argument!
            exit 1
        fi
        shift
    else
        break
    fi
done


if [ $(dnsdomainname) != ics.hut.fi ]
then
    echo This script is only meant to be used within the Aalto ICS environment!
    exit 1
fi

if [ ! -e build/ ]
then
    mkdir build
elif [ ! -d build ]
then
    echo Fatal error: build exists but is not a directory!
    exit 1
fi

echo Installing shared files where not found...

create_dir_if_not_exist() {
    if [ ! -e $1 ]
    then
        mkdir $1
    elif [ ! -d $1 ]
    then 
        echo $1 already exists but is not a directory!
        exit 1
    fi
}
    
create_dir_if_not_exist $HOME/slmotion
create_dir_if_not_exist $HOME/slmotion/share
create_dir_if_not_exist $HOME/slmotion/share/flandmark
# /home/jmkarppa/slmotion/share/flandmark/flandmark_model.dat

echo Entering build...

cd build

if [ -e CMakeCache.txt ]; then
    echo "CMake cache found, doing a quick&dirty build (use --clean if you want a clean build)"
else
    echo "No CMakeCache found, doing a clean build"
    echo Running CMake...
    cmake -D CMAKE_INSTALL_PREFIX=$HOME/slmotion -D ENABLE_PICSOM=ON \
        -D ENABLE_LIBHAND=ON -D ENABLE_LIBFLANDMARK=ON -D ENABLE_OPENNI=OFF \
        -D ENABLE_VIDFILE=ON \
        -D LIBFLANDMARK_DIR=/share/imagedb/slmotion/libflandmark_opencv_242 \
        -D LIBVIDREADER_DIR=/share/imagedb/slmotion/vid_reader \
        -D MAKE_TESTS=ON \
        -D MAKE_TESTI=ON \
        -D MAKE_TRAINELM=ON \
        -D MAKE_HANDCONFIGURATIONEDITOR=ON \
        -D OPENNI_DIR=/share/imagedb/slmotion/OpenNI-Bin-Dev-Linux-x64-v1.5.2.23 \
        -D OPENNI_INSTALL_DIR=/share/imagedb/slmotion/openni \
        -D OPENNI_MODULES_DIR=/share/imagedb/slmotion/openni \
        -D TEST_DATA_DIRECTORY=/share/imagedb/slmotion/tests \
        -D USE_CUSTOM_OPENCV=ON \
        -D ENABLE_GTK=ON \
        -D ENABLE_LIBLBFGS=ON \
        -D ENABLE_LIBSVM=ON \
        ..
fi

echo Running make...
make -j5
echo Running make install...
make install
echo Done.