#!/bin/sh

 LIBFLANDMARKDIR=/share/imagedb/slmotion/libflandmark

for SRC in FacialLandmarkDetector.cpp tritontest.cpp \
    OpenCVVideoCaptureVideoFileSource.cpp VideoFileSource.cpp FrameSource.cpp \
    Component.cpp TrackingSkinDetector.cpp ViolaJonesFaceDetector.cpp Blob.cpp \
    PropagationSkinDetector.cpp FeatureExtractor.cpp VviComponent.cpp \
    ELMClassifier.cpp BinaryClassifier.cpp SkinDetector.cpp util.cpp \
    Classifier.cpp ColourSpace.cpp Filter.cpp FaceDetector.cpp
do
    echo Compiling $SRC...
    g++-4.4 -g -std=c++0x -c $SRC -o $(basename $SRC .cpp).o \
        -DSLMOTION_ENABLE_LIBFLANDMARK \
        -I/usr/include/libxml2/ -D__STDC_LIMIT_MACROS -D__STDC_CONSTANT_MACROS \
        -DSLMOTION_BOOST_REGEX \
        -I$LIBFLANDMARKDIR -DSLMOTION_LIBFLANDMARK_MODEL="\"$LIBFLANDMARKDIR/flandmark_model.dat\""
done

echo Linking...
g++-4.4 -g -std=c++0x OpenCVVideoCaptureVideoFileSource.o \
    ViolaJonesFaceDetector.o\
    VideoFileSource.o FrameSource.o Component.o FacialLandmarkDetector.o \
    tritontest.o TrackingSkinDetector.o Blob.o PropagationSkinDetector.o \
    FeatureExtractor.o VviComponent.o ELMClassifier.o BinaryClassifier.o \
    SkinDetector.o util.o Classifier.o ColourSpace.o Filter.o FaceDetector.o \
    -lboost_program_options -L$LIBFLANDMARKDIR -Wl,-rpath=$LIBFLANDMARKDIR \
    -lflandmark \
    $(pkg-config --libs opencv) -o tritontest -lboost_regex -lblas -llapack