#!/bin/sh

if [ `id -u` -eq 0 ]; then
    echo Do not run this script as root.
    exit 1
fi

echo Checking installed files... \\c

SLMOTION_PREFIX=$HOME/slmotion/

if [ ! -d $SLMOTION_PREFIX ]; then
    echo Fail!
    echo $0: $SLMOTION_PREFIX does not exist!
    exit 1
fi

for dir in bin lib share
do
    if [ ! -d $SLMOTION_PREFIX/$dir ]; then
        echo Fail!
        echo $0: $SLMOTION_PREFIX/$dir does not exist!
        exit 1
    fi
done

FILES="bin/slmotion bin/slmotiongui lib/"
for file in $FILES
do
    if [ ! -e $SLMOTION_PREFIX/$file ]; then
        echo Fail!
        echo $0: $SLMOTION_PREFIX/$file does not exist!
        exit 1
    fi
done

echo OK

if [ -e slmotion.app ]; then
    echo Warning: slmotion.app already exists. The directory will be removed.
    echo If you do not want to proceed, hit Ctrl-C *NOW*
    for i in `seq 5 1`
    do
        echo $i... \\c
        sleep 1s
    done
    rm -rf slmotion.app
    echo Done.
fi

echo Creating empty bundle structure...
mkdir -v slmotion.app
mkdir -v slmotion.app/Contents
mkdir -v slmotion.app/Contents/MacOS
mkdir -v slmotion.app/Contents/Resources

echo Copying executable binaries...
cp -v $SLMOTION_PREFIX/bin/slmotion slmotion.app/Contents/MacOS
cp -v $SLMOTION_PREFIX/bin/slmotiongui slmotion.app/Contents/MacOS/slmotiongui.bin
cp -v slmotiongui-launcher.sh slmotion.app/Contents/MacOS/slmotiongui
chmod a+x slmotion.app/Contents/MacOS/slmotiongui
echo Copyng resources...
cp -vR $SLMOTION_PREFIX/lib $SLMOTION_PREFIX/share slmotion.app/Contents/Resources

echo Creating Info.plist... \\c

cat <<EOF > slmotion.app/Contents/Info.plist
<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE plist PUBLIC "-//Apple Computer//DTD PLIST 1.0//EN" "http://www.apple.com/DTDs/PropertyList-1.0.dtd">
<plist version="1.0">
<dict>
    <key>CFBundleDevelopmentRegion</key>
    <string>English</string>
    <key>CFBundleExecutable</key>
    <string>slmotiongui</string>
    <key>CFBundleGetInfoString</key>
    <string>0.1.0, (c) 2014 Aalto University</string>
    <!-- <key>CFBundleIconFile</key>
    <string>.icns</string> -->
    <key>CFBundleIdentifier</key>
    <string>fi.aalto.slmotion</string>
    <key>CFBundleInfoDictionaryVersion</key>
    <string>6.0</string>
    <key>CFBundlePackageType</key>
    <string>APPL</string>
    <key>CFBundleShortVersionString</key>
    <string>0.1.0</string>
    <key>CFBundleSignature</key>
    <string>????</string>
    <!-- <key>CFBundleVersion</key>
    <string>0.1.0</string> -->
    <key>NSHumanReadableCopyright</key>
    <string>Copyright 2014 Aalto University, FreeBSD Licence.</string>
    <key>LSMinimumSystemVersion</key>
    <string>10.8</string>
</dict>
</plist>
EOF
echo OK

echo Fixing install_names...
for file in slmotion.app/Contents/MacOS/* slmotion.app/Contents/Resources/lib/*.dylib slmotion.app/Contents/Resources/lib/python2.7/site-packages/cv2.so
do
    echo $file
    otool -L $file | grep "@executable" | cut -d ' ' -f 1 | sed 's/^.*@/@/' |
    while read dep
    do
        newdep=$(echo $dep | sed 's/..\/lib/..\/Resources\/lib/')
        echo "$file: $dep -> $newdep"
        install_name_tool -change $dep $newdep $file
    done
done

for file in slmotion.app/Contents/Resources/lib/*.dylib
do
    newid="@executable_path/../Resources/lib/$(basename $file)"
    install_name_tool -id "$newid" "$file"
    echo "id: $file -> $newid"
done