#!/bin/sh

# this is a script that will compile slmotion and all of its dependencies for mac

if [ `id -u` -eq 0 ]; then
    echo Do not run this script as root.
    exit 1
fi

if [ ! -e macenv ]; then
    mkdir macenv
elif [ ! -d macenv ]; then
    echo "Error: macenv exists and is not a directory!"
    exit 1
fi

MACENV=`pwd`/macenv

# By default, use CXX. If undefined, use g++

if [ -z "$CXX" ]; then
    CXX=g++
fi

echo Checking G++ version... \\c
GCC_VERSION_STRING=`$CXX --version|grep '[0-9]\.[0-9]*\.[0-9]*'|sed 's/.* \([0-9]\.[0-9]*\.[0-9]\).*/\1/'`
echo $GCC_VERSION_STRING... \\c
GCC_MAJOR_VERSION=`echo $GCC_VERSION_STRING|cut -d '.' -f 1`
GCC_MINOR_VERSION=`echo $GCC_VERSION_STRING|cut -d '.' -f 2`
if [ $GCC_MAJOR_VERSION = 4 -a $GCC_MINOR_VERSION -ge 6 -o $GCC_MAJOR_VERSION -gt 4 ]; then
    echo OK
else
    echo FAIL!
    echo GCC 4.6 or greater is required!
    exit 1
fi

echo Checking for CMake... \\c
if [ `cmake --version|wc -l` -ge 1 ]; then
    echo OK
else
    echo FAIL!
    exit 1
fi

echo Checking GTK... \\c
if [ ! -e $MACENV/lib/libgtk-quartz-2.0.dylib ]; then
    echo "Error: GTK is not installed. Please install it in $MACENV before proceeding by performing the following steps:"
    echo \(i\) Download and run http://git.gnome.org/browse/gtk-osx/plain/gtk-osx-build-setup.sh
    echo \(ii\) Add the following line to $HOME/.jhbuildrc at the location where the prefix is defined \(do this manually\):
    echo     prefix = '/Users/masa/git/slmotion/macenv'
    echo \(iii\) Run the following commands:
    echo  ~/.local/bin/jhbuild bootstrap
    echo  ~/.local/bin/jhbuild build meta-gtk-osx-bootstrap
    echo  ~/.local/bin/jhbuild build meta-gtk-osx-core
    echo
    echo Afterwards, you should have a working GTK installation. Please note that this procedure is *INCOMPATIBLE* with macports and fink.
    exit 1
fi

echo Checking for Boost... \\c
if [ ! -e $MACENV/lib/libboost_regex.dylib ]; then
    echo Not found!
    echo Checking for boost_1_54_0... \\c
    if [ ! -d boost_1_54_0 ]; then
        echo Not found!
        echo Checking for boost_1_54_0.tar.bz2... \\c
        if [ ! -e boost_1_54_0.tar.bz2 ]; then
            echo Not found!
            echo Downloading boost_1_54_0.tar.bz2...
            wget https://sourceforge.net/projects/boost/files/boost/1.54.0/boost_1_54_0.tar.bz2/download -O boost_1_54_0.tar.bz2
        fi
        echo Verifying checksum... \\c
        if [ `md5 -q boost_1_54_0.tar.bz2` != 15cb8c0803064faef0c4ddf5bc5ca279 ]; then
            echo ERROR!
            echo Checksum mismatch.
            exit 1
        fi
        echo OK
        echo Extracting... \\c
        tar xjf boost_1_54_0.tar.bz2
        echo OK
    else
        echo OK
    fi
    echo Entering boost_1_54_0/
    cd boost_1_54_0/
    echo Bootstrapping Boost...
    # ensure correct GCC gets selected
    OLDPATH=$PATH
    export PATH=`dirname $CXX`:$PATH
    echo "using darwin : : $CXX ;" >> tools/build/v2/user-config.jam
    ./bootstrap.sh --prefix="$MACENV"
    echo Building Boost...
    ./b2 --prefix="$MACENV" install
    export PATH=$OLDPATH
    echo Leaving boost_1_54_0/
    cd ..
else
    echo OK
fi

# OpenNI requires this

OLD_CC=$CC
export CC=/usr/bin/gcc
echo Checking for libusb/... \\c
if [ ! -e $MACENV/lib/libusb-1.0.0.dylib ]; then
    echo Not found!
    echo Checking for libusb-1.0.9.tar.bz2... \\c
    if [ ! -e libusb-1.0.9.tar.bz2 ]; then
        echo Not found!
        echo Downloading libusb-1.0.9.tar.bz2...
        wget http://sourceforge.net/projects/libusb/files/libusb-1.0/libusb-1.0.9/libusb-1.0.9.tar.bz2
    fi
    echo Verifying checksum... \\c
    if [ `md5 -q libusb-1.0.9.tar.bz2` != 7f5a02375ad960d4e33a6dae7d63cfcb ]; then
        echo ERROR!
        echo Checksum mismatch!
        exit 1
    else
        echo OK
    fi
    echo Extracting... \\c
    tar xjf libusb-1.0.9.tar.bz2
    echo OK
    echo Entering libusb-1.0.9/...
    cd libusb-1.0.9
    echo Running configure...
    ./configure --prefix=$MACENV
    echo Running make...
    make
    echo Installing...
    make install
    echo Leaving libusb-1.0.9/...
    cd ..
else
    echo OK
fi

export CC=$OLD_CC

# this is for future openni2 support

# OPENNI_DIR=`pwd`/openni
# echo Checking for OpenNI/... \\c
# if [ ! -d openni/ ]; then
#     echo Not found!
#     echo Checking for OpenNI-MacOSX-x64-2.2.0/... \\c
#     if [ ! -d OpenNI-MacOSX-x64-2.2.0 ]; then
#         echo Not found!
#         echo Checking for OpenNI-MacOSX-x64-2.2.0.tar.bz2... \\c
#         if [ ! -e OpenNI-MacOSX-x64-2.2.0.tar.bz2 ]; then
#             echo Not found!
#             echo Checking for MacOSX.zip... \\c
#             if [ ! -e MacOSX.zip ]; then
#                 echo Not found!
#                 echo Downloading MacOSX.zip...
#                 wget http://www.openni.org/wp-content/uploads/2013/05/MacOSX.zip
#             fi
#             echo Verifying checksum... \\c
#             if [ `md5 -q MacOSX.zip` != 464ff59d7c30ecaf859becfc0c857241 ]; then
#                 echo ERROR!
#                 echo Checksum mismatch.
#                 exit 1
#             fi
#             echo OK
#             echo Extracting... \\c
#             unzip -j MacOSX.zip
#             echo OK
#         else
#             echo OK
#         fi
#         echo Verifying checksum... \\c
#         if [ `md5 -q OpenNI-MacOSX-x64-2.2.0.tar.bz2` != 7cda6be6d5a94b190b436897bf34e78a ]; then
#             echo ERROR!
#             echo Checksum mismatch.
#             exit 1
#         fi
#         echo OK
#         echo Extracting... \\c
#         tar xjf OpenNI-MacOSX-x64-2.2.0.tar.bz2
#         echo OK        
#     else
#         echo OK
#     fi
#     echo Creating openni/
#     mkdir openni
#     echo Entering OpenNI-MacOSX-x64-2.2.0
#     cd OpenNI-MacOSX-x64-2.2.0
#     echo Leaving OpenNI-MacOSX-x64-2.2.0
#     cd ..
# else
#     echo OK
# fi

OPENNI_DIR=$MACENV
OPENNI_SRC_DIR=`pwd`/OpenNI-Bin-Dev-MacOSX-v1.5.4.0
echo Checking for openni/... \\c
if [ ! -e $MACENV/var/lib/ni/modules.xml ]; then
    echo Not found!
    echo Checking for OpenNI-Bin-Dev-MacOSX-v1.5.4.0/... \\c
    if [ ! -d OpenNI-Bin-Dev-MacOSX-v1.5.4.0 ]; then
        echo Not found!
        echo Checking for OpenNI-Bin-Dev-MacOSX-v1.5.4.0.tar.zip... \\c
        if [ ! -e OpenNI-Bin-Dev-MacOSX-v1.5.4.0.tar.zip ]; then
            echo Not found!
            echo OpenNI-Bin-Dev-MacOSX-v1.5.4.0.tar.zip...
            wget http://www.openni.org/wp-content/uploads/2012/12/OpenNI-Bin-Dev-MacOSX-v1.5.4.0.tar.zip
        fi
        echo Verifying checksum... \\c
        if [ `md5 -q OpenNI-Bin-Dev-MacOSX-v1.5.4.0.tar.zip` != eecd5f235af13bfe49dc06dbf28c725d ];
        then
            echo ERROR!
            echo Checksum mismatch.
            exit 1
        fi
        echo OK
        echo Extracting... \\c
        unzip -p OpenNI-Bin-Dev-MacOSX-v1.5.4.0.tar.zip|tar xj
        echo OK
    else
        echo OK
    fi
    echo Entering OpenNI-Bin-Dev-MacOSX-v1.5.4.0
    cd OpenNI-Bin-Dev-MacOSX-v1.5.4.0
    # sh install.sh -i -c $OPENNI_DIR
    mkdir $OPENNI_DIR/usr
    mkdir $OPENNI_DIR/usr/lib
    cp Lib/*.dylib $OPENNI_DIR/usr/lib
    install_name_tool -id libOpenNI.dylib $OPENNI_DIR/usr/lib/libOpenNI.dylib
    for module in libnimMockNodes.dylib libnimCodecs.dylib libnimRecorder.dylib; do
        install_name_tool -id $module $OPENNI_DIR/usr/lib/$module
        install_name_tool -change ../../Bin/x64-Release/libOpenNI.dylib \
            libOpenNI.dylib $OPENNI_DIR/usr/lib/$module
    done
    install_name_tool -change /opt/local/lib/libusb-1.0.0.dylib \
        $MACENV/lib/libusb-1.0.0.dylib $OPENNI_DIR/usr/lib/libOpenNI.dylib 
    mkdir $OPENNI_DIR/usr/include
    mkdir $OPENNI_DIR/usr/include/ni
    cp Include/*.h $OPENNI_DIR/usr/include/ni
    mkdir $OPENNI_DIR/var
    mkdir $OPENNI_DIR/var/lib
    mkdir $OPENNI_DIR/var/lib/ni
    cat > $OPENNI_DIR/var/lib/ni/modules.xml << EOF
<Modules>
    <Module path="$MACENV/usr/lib/libnimMockNodes.dylib" />
    <Module path="$MACENV/usr/lib/libnimCodecs.dylib" />
    <Module path="$MACENV/usr/lib/libnimRecorder.dylib" />
</Modules>
EOF
    echo Leaving OpenNI-Bin-Dev-MacOSX-v1.5.4.0
    cd ..

    for file in /Users/masa/git/slmotion/macenv/usr/lib/lib*
    do
        install_name_tool -id $file $file
        install_name_tool -change libOpenNI.dylib $MACENV/usr/lib/libOpenNI.dylib $file
    done
else
    echo OK
fi

echo Checking for ffmpeg/... \\c
if [ ! -e $MACENV/lib/libavcodec.dylib ]; then
    echo Not found!
    echo Checking for ffmpeg-1.2/... \\c
    if [ ! -d ffmpeg-1.2 ]; then
        echo Not found!
        echo Checking for ffmpeg-1.2.tar.bz2... \\c
        if [ ! -e ffmpeg-1.2.tar.bz2 ]; then
            echo Not found!
            echo Downloading...
            wget http://www.ffmpeg.org/releases/ffmpeg-1.2.tar.bz2
        else
            echo OK
        fi

        echo Verifying checksum... \\c
        if [ `md5 -q ffmpeg-1.2.tar.bz2` = c871d20559cb64c015b5cf0858812a56 ]; then
            echo OK
        else
            echo ERROR!
            echo Checksum mismatch.
            exit 1
        fi

        echo Extracting... \\c
        tar xjf ffmpeg-1.2.tar.bz2
        echo OK
    else
        echo OK
    fi

    echo Entering ffmpeg-1.2/
    cd ffmpeg-1.2

    echo Configuring...
    ./configure --prefix=$MACENV --enable-shared --enable-pic

    echo Running make...
    make

    echo Installing...
    make install

    echo Leaving ffmpeg-1.2/
    cd ..

else
    echo OK
fi

# these are necessary for cmake to locate our custom ffmpeg
export DYLD_LIBRARY_PATH=$DYLD_LIBRARY_PATH:$MACENV/lib/
export PKG_CONFIG_PATH=$PKG_CONFIG_PATH:$MACENV/lib/pkgconfig
export PKG_CONFIG_LIBDIR=$PKG_CONFIG_LIBDIR:$MACENV/lib

echo Checking for OpenCV... \\c
if [ ! -e $MACENV/lib/libopencv_core.dylib ]; then
    echo Not found!
    echo Checking for opencv-2.4.5/... \\c
    if [ ! -d opencv-2.4.5/ ]; then
        echo Not found!
        echo Checkig for opencv-2.4.5.tar.gz... \\c
        if [ ! -e opencv-2.4.5.tar.gz ]; then
            echo Not found!
            echo Downloading...
            wget http://sourceforge.net/projects/opencvlibrary/files/opencv-unix/2.4.5/opencv-2.4.5.tar.gz/download -O opencv-2.4.5.tar.gz
        else
            echo OK
        fi
            
        echo Verifying checksum... \\c
        if [ `md5 -q opencv-2.4.5.tar.gz` != 8eac87462c7bec8b89021b723207c623 ]; then
            echo Checksum mismatch!
            exit 1
        else
            echo OK
        fi
            
        echo Extracting... \\c
        tar xzf opencv-2.4.5.tar.gz
        echo OK
    else
        echo OK
    fi
    echo Entering opencv-2.4.5/
    cd opencv-2.4.5
    echo Creating opencv-2.4.5/build
    mkdir build/
    echo Entering opencv-2.4.5/build
    cd build/
        
    echo Checking Apple GCC... \\c
    if [ ! `/usr/bin/g++ --version|grep 'i686-apple-darwin11-llvm-g++-4.2'|wc -l` -eq 1 ];
    then
        echo Not found!
        echo OpenCV must be compiled with Apple GCC because of some Objective-C dependencies
        exit 1
    else
        echo OK
    fi
        
    echo Running CMake...
    # some parts of opencv (most notably highgui) need to be compiled with 
    # the Apple compiler
    CXX_BAK=$CXX
    export CXX=/usr/bin/g++
#    cmake -G "Unix Makefiles" -D CMAKE_BUILD_TYPE=RELEASE \
#        -D CMAKE_INSTALL_PREFIX=$MACENV \
#        -D BUILD_PYTHON_SUPPORT=ON -D WITH_FFMPEG=ON \
#        -D FFMPEG_INCLUDE_DIR=$FFMPEG_DIR/include  ..
    export CXX=$CXX_BAK

    echo Running make...
    make
        
    echo Installing OpenCV...
    make install
        
    echo Leaving opencv-2.4.5/build
    cd ..
    echo Leaving opencv-2.4.5/
    cd ..

    echo Fixing library install names...
    for file in $MACENV/lib/libopencv*.dylib $MACENV/lib/python2.7/site-packages/cv2.so
    do
        otool -L $file|cut -f 1 -d ' '| sed 's/[^a-z]//'|egrep -v '^/' | while read lib
        do
            if [[ $lib == lib/* ]]; then
                install_name_tool -change $lib $MACENV/lib/`echo $lib|sed 's/lib\///'` $file
            fi
        done
    done
else
    echo OK
fi

echo Checking for libflandmark... \\c
if [ ! -e $MACENV/lib/libflandmark.dylib ]; then
    echo Not found!
    echo Checking for flandmark_v107/... \\c
    if [ ! -d flandmark-master ]; then
        echo Not found!
        echo Checking for flandmark_v107.zip... \\c
        if [ ! -e flandmark_v107.zip ]; then
            echo Not found!
            echo Downloading...
            wget "http://cmp.felk.cvut.cz/~uricamic/flandmark/ccount/click.php?id=7" \
                -O flandmark_v107.zip
        else 
            echo OK
        fi
        echo Verifying checksum... \\c
        if [ `md5 -q flandmark_v107.zip` != 95acd7d73100d3460e6727ce3ecfe17d ]; then
            echo ERROR!
            echo Checksum mismatch!
            exit 1
        else
            echo OK
        fi
        echo Extracting... \\c
        unzip flandmark_v107.zip > /dev/null
        echo OK
    else
        echo OK
    fi
    echo Entering flandmark-master/
    cd flandmark-master
    echo Patching libflandmark/CMakeLists.txt... \\c
    head -n 2 libflandmark/CMakeLists.txt > libflandmark/CMakeLists.txt.new
    echo "link_directories($MACENV/lib)" >> libflandmark/CMakeLists.txt.new
    tail -n +2 libflandmark/CMakeLists.txt >> libflandmark/CMakeLists.txt.new
    mv libflandmark/CMakeLists.txt.new libflandmark/CMakeLists.txt
    echo Creating bin/
    mkdir bin
    echo Entering bin/
    cd bin
    echo Running CMake...
    cmake -D CMAKE_PREFIX_PATH=$MACENV/share/OpenCV \
        -D CMAKE_INSTALL_PREFIX=$MACENV -D BUILD_MATLAB_BINDINGS=OFF \
        -D BUILD_CPP_EXAMPLES=OFF ..
    make
    echo Copying library files... \\c
    cp libflandmark/libflandmark_shared.dylib $MACENV/lib
    cp libflandmark/libflandmark_shared.dylib $MACENV/lib/libflandmark.dylib
    cp ../libflandmark/*.h $MACENV/include
    if [ ! -d $MACENV/share/flandmark ]; then
        mkdir $MACENV/share/flandmark
    fi
    cp ../data/flandmark_model.dat $MACENV/share/flandmark
    echo OK
    cd ..
    cd ..

    echo Fixing library install names...
    install_name_tool -id $MACENV/lib/libflandmark.dylib $MACENV/lib/libflandmark.dylib
    for file in $MACENV/lib/libflandmark.dylib $MACENV/lib/libflandmark_shared.dylib
    do
        otool -L $file|cut -f 1 -d ' '| sed 's/[^a-z]//'|egrep -v '^/' | while read lib
        do
            if [[ $lib == lib/* ]]; then
                install_name_tool -change $lib $MACENV/lib/`echo $lib|sed 's/lib\///'` $file
            fi
        done
    done

else
    echo OK
fi

if [ ! -d build/ ]; then
    echo Creating build/
    mkdir build
fi
echo Entering build/
cd build

if [ ! -e Makefile ]; then
    echo Running CMake...
    export PATH=$MACENV/bin:$PATH
    export PKG_CONFIG_PATH=$MACENV/lib/pkgconfig
    export PKG_CONFIG_LIBDIR=$MACENV/lib
    export CMAKE_PREFIX_PATH=$MACENV/share/OpenCV
    cmake -D OpenCV_DIR=$MACENV/share/OpenCV \
        -D USE_CUSTOM_BOOST=ON -D CUSTOM_BOOST_DIR=$MACENV -D ENABLE_PICSOM=OFF \
        -D OPENNI_DIR=$OPENNI_SRC_DIR \
        -D OPENNI_INSTALL_DIR=$OPENNI_DIR -D OPENNI_MODULES_DIR=$MACENV -D ENABLE_OPENNI=ON \
        -D ENABLE_LIBFLANDMARK=ON -D LIBFLANDMARK_DIR=$MACENV/share/flandmark \
        -D CMAKE_INSTALL_PREFIX=$MACENV \
        -D TEST_DATA_DIRECTORY=/Users/masa/slmotion_tests ..
fi

echo Running make...
make

cd ..

if [ ! -d $MACENV/share/slmotion ]; then
    mkdir $MACENV/share/slmotion
fi

echo Fixing library install names...

for file in build/slmotion build/tests build/libslmotion.dylib build/slmotiongui
do 
    otool -L $file|cut -f 1 -d ' '| sed 's/[^a-z]//'|egrep -v '^/' | while read lib
    do
        if [[ $lib == lib/* ]]; then
            install_name_tool -change $lib $MACENV/lib/`echo $lib|sed 's/lib\///'` $file
        elif [[ $lib == libOpenNI.dylib ]]; then
            install_name_tool -change $lib $MACENV/usr/lib/$lib $file
        else
            install_name_tool -change $lib $MACENV/lib/$lib $file
        fi
    done
    otool -L $file|cut -f 1 -d ' '| sed 's/[^a-z]//'|egrep '^/usr/local' | while read lib
    do
        install_name_tool -change $lib $MACENV/lib/`basename $lib` $file
    done
    install_name_tool -change `pwd`/flandmark-master/bin/libflandmark/libflandmark_shared.dylib $MACENV/lib/libflandmark.dylib $file
done

for file in build/slmotion build/tests build/slmotiongui
do
    install_name_tool -change `pwd`/build/libslmotion.dylib $MACENV/lib/libslmotion.dylib $file
done

cd build 

echo Running make install...
make install

echo Done.


cd ..

