#!/bin/sh

# makes an exportable binary version

echo Copying necessary binaries, and changing their install paths...

cd build
if [ -e libfiles.txt ]; then
    rm libfiles.txt
fi
touch libfiles.txt

MAY_QUIT=false
while [ $MAY_QUIT != true ]; do
    MAY_QUIT=true
    for file in slmotion tests slmotiongui *.dylib; do
        if [ `otool -D $file | grep '^/'|wc -l` = 1 ]; then
            OLDID=`otool -D $file|grep -v ':$'`
            echo "$file: Changing id $OLDID -> $file"
            install_name_tool -id $file $file
        fi
        
        otool -L $file|cut -f 1 -d ' '|sed 's/^[^a-z/A-Z0-9\.]*//'|grep -v ':$'| \
            grep '^/'| grep -v '^/usr/lib/[a-zA-Z.0-9+]*.dylib$'| \
            grep -v '^/System' | while read lib
        do 
            MAY_QUIT=false
            if [ ! -e `basename $lib` ]; then
                cp $lib `basename $lib`
                echo Copying "$lib -> `basename $lib`"
            fi
            echo "$file: Changing dependency name $lib -> `basename $lib`"
            install_name_tool -change $lib `basename $lib` $file
        done
    done
done
echo Done.