#!/bin/sh

if [ `id -u` -eq 0 ]; then
    echo Do not run this script as root.
    exit 1
fi

if [ "$#" -ne 2 ]
then
    echo Usage:
    echo "$0 <src dir> <install prefix>"
    echo This script will try to fix the rpath of an slmotion installation.
    exit 0
fi

SRC_DIR=$1
INSTALL_PREFIX=$2

if [ ! -e $INSTALL_PREFIX/lib/libslmotion.dylib ]
then
    echo ERROR: $INSTALL_PREFIX/lib/libslmotion.dylib does not exist!
    exit 1
fi 

if [ ! -d $INSTALL_PREFIX/lib/python2.7 ]
then
    echo Creating $INSTALL_PREFIX/lib/python2.7...
    mkdir $INSTALL_PREFIX/lib/python2.7
fi

if [ ! -d $INSTALL_PREFIX/lib/python2.7/site-packages ]
then
    echo Creating $INSTALL_PREFIX/lib/python2.7/site-packages...
    mkdir $INSTALL_PREFIX/lib/python2.7/site-packages
fi

if [ ! -e $INSTALL_PREFIX/lib/python2.7/site-packages/cv.py ]
then
    cp -v $SRC_DIR/opencv/lib/python2.7/site-packages/cv.py $INSTALL_PREFIX/lib/python2.7/site-packages
fi

if [ ! -e $INSTALL_PREFIX/lib/python2.7/site-packages/cv2.so ]
then
    cp -v $SRC_DIR/opencv/lib/python2.7/site-packages/cv2.so $INSTALL_PREFIX/lib/python2.7/site-packages
fi

CAN_QUIT=false
while [ $CAN_QUIT != true ]
do
    CAN_QUIT=true
    for file in $INSTALL_PREFIX/bin/* $INSTALL_PREFIX/lib/*.dylib $INSTALL_PREFIX/lib/python2.7/site-packages/cv2.so
    do
        DEPCOUNT=$(otool -L $file|grep -v /System|grep -v /usr | grep -v Qt | \
            grep -v 'executable_path' | grep -v ':$' | grep -v "cv2.so" | \
            cut -d ' ' -f 1 | wc -l)
        if [ $DEPCOUNT -gt 0 ]
        then
            CAN_QUIT=false
            otool -L $file|grep -v /System|grep -v /usr | grep -v Qt | \
            grep -v 'executable_path' | grep -v ':$' | cut -d ' ' -f 1 | \
            while read lib
            do
                dep=$lib
                lib=$(echo $lib | sed 's/.*\///')
                if $(echo $lib | grep -q '.dylib')
                then
                    if [ ! -e "$INSTALL_PREFIX/lib/$lib" ]
                    then
                        cp -v $SRC_DIR/*/lib/$lib $INSTALL_PREFIX/lib
                    fi
                fi
                echo "$file: Changing dependency $dep -> @executable_path/../lib/$lib"
                install_name_tool -change "$dep" "@executable_path/../lib/$lib" "$file"
            done
            if $(echo $file | grep -q '.dylib')
            then
                lib=$(echo $file | sed 's/.*\///')
                echo "$file: Changing id to @executable_path/../lib/$lib"
                install_name_tool -id "@executable_path/../lib/$lib" "$file"
            elif $(echo $file | grep -q 'cv.so')
            then
                lib=$(echo $file | sed 's/.*\///')
                echo "$file: Changing id to @executable_path/../lib/python2.7/site-packages/$lib"
                install_name_tool -id "@executable_path/../lib/python2.7/site-packages/$lib" "$file"
            fi
        fi
    done
done