// this contains some python api specific implementation

#include "pythonapi.hpp"
#include "PythonException.hpp"
#include "CsvToEafConverter.hpp"
#include "regex.hpp"
#include "util.hpp"
#include <fstream>
#include <signal.h>

using namespace slmotion::configuration;
using boost::program_options::option_description;
using std::shared_ptr;
using std::vector;
namespace bp = boost::python;



namespace slmotion {
  namespace python { 
    // these functions do the magic for getRow()
    template<typename T>
    static boost::python::list get1ChannelRow(const cv::Mat& m, int rowIdx) {
      boost::python::list row;
      for (int colIdx = 0; colIdx < m.cols; ++colIdx)
        row.append(m.at<T>(rowIdx, colIdx));
      return row;
    }



    template<typename T, int nChannels>
    static boost::python::list getMultiChannelRow(const cv::Mat& m, int rowIdx) {
      boost::python::list row;       
      for (int colIdx = 0; colIdx < m.cols; ++colIdx) {
        const cv::Vec<T,nChannels>& v = 
          m.at<cv::Vec<T,nChannels> >(rowIdx, colIdx);
        boost::python::list vector;
        for (int k = 0; k < nChannels; ++k)
          vector.append(v[k]);
        row.append(vector);
      }
      return row;
    }



    template<typename T> 
    static bp::object convertToPythonObject(const T& e) {
      return e;
    }
  }
}

